const {Accion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Acciones
exports.getAccionAll = async (req, res) => {
  try {
    const acciones = await Accion.findAll(
      {
        include: [
          {
            model: Incidencia,
            as: 'incidencia'
          }
        ]
      }
    );
    logger.info("Accion obtenidos correctamente");
    res.json(acciones);
  } catch (error) {
    logger.error("Error al obtener Accion: " + error.message);
    res.status(500).json({ error: "Error al obtener Acciones" });
  }
};
// Obtener una Accion por el hallazgo o incidencia
exports.getAccionByIncidencia = async (req, res) => {
  try {
    const { incidencia } = req.params;
    const acciones = await Accion.findAll(
      {
        where: {
          HallazgoId: incidencia
        }
      }
    );
    if (!acciones) {
      logger.error("Accion no encontrada por su ID");
      return res.status(404).json({ error: "Accion no encontrada" });
    }
    logger.info("Accion obtenido correctamente por su ID");
    res.json(acciones);
  } catch (error) {
    logger.error("Error al obtener el Accion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Accion" });
  }
};
// Obtener una Accion por ID
exports.getAccionById = async (req, res) => {
  try {
    const accion = await Accion.findByPk(req.params.id);
    if (!accion) {
      logger.error("Accion no encontrada por su ID");
      return res.status(404).json({ error: "Accion no encontrada" });
    }
    logger.info("Accion obtenido correctamente por su ID");
    res.json(accion);
  } catch (error) {
    logger.error("Error al obtener el Accion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Accion" });
  }
};

// Crear una Accion
exports.createAccion = async (req, res) => {
  try {
    const accion = await Accion.create(req.body);
    logger.info("Accion creado correctamente");
    res.status(201).json(accion);
  } catch (error) {
    logger.error("Error al crear un Accion: " + error.message);
    res.status(500).json({ error: "Error al crear Accion" });
  }
};

// Actualizar una Accion
exports.updateAccion = async (req, res) => {
  try {
    const accion = await Accion.findByPk(req.params.id);
    if (!accion) {
      logger.error("Accion no encontrada por su ID");
      return res.status(404).json({ error: "Accion no encontrada" });
    }
    await accion.update(req.body);
    logger.info("Accion actualizado correctamente");
    res.json(accion);
  } catch (error) {
    logger.error("Error al actualizar un Accion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Accion" });
  }
};

// Eliminar una Accion
exports.deleteAccion = async (req, res) => {
  try {
    const accion = await Accion.findByPk(req.params.id);
    if (!accion) {
      logger.error("Accion no encontrada por su ID");
      return res.status(404).json({ error: "Accion no encontrada" });
    }
    await Accion.destroy();
    logger.info("Accion eliminado correctamente");
    res.json({ message: "Accion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Accion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Accion" });
  }
};

