const {Agendamiento} = require('../models');
const logger = require('../middlewares/logger.middleware');

// Obtener todas las Agendamientoes
exports.getAgendamientoAll = async (req, res) => {
  try {
    const citas = await Agendamiento.findAll();
    logger.info('Agendamientos obtenidos correctamente');
    res.json(citas);
  } catch (error) {
    logger.error('Error al obtener Agendamientos: ' + error.message);
    res.status(500).json({ error: 'Error al obtener Agendamientoes' });
  }
};

// Obtener las citas por sede y personal (odontologo)
exports.getAgendamientoByPersonal = async (req, res) => {
  try {
    const { personal } = req.params;
    const citas = await Agendamiento.findAll(
      {
        where: {
          OdontologoId: personal
        }
      }
    );
    if (!citas) {
      logger.error('Agendamiento no encontrado por su asociacion con Odontologo');
      return res.status(404).json({ error: 'Agendamientos no encontrada' });
    }
    logger.info('Agendamientos obtenidas correctamente por su asociacion con el Odontologo');
    res.json(citas);
  } catch (error) {
    logger.error('Error al obtener Agendamientos por Odontologo: ' + error.message);
    res.status(500).json({ error: 'Error al obtener Agendamientos' });
  }
};

// Obtener las citas por sede y personal (odontologo)
exports.getAgendamientoBySedeandPersonal = async (req, res) => {
  try {
    const { sede, personal } = req.params;
    const citas = await Agendamiento.findAll(
      {
        where: {
          SedeIdentificador: sede,
          OdontologoId: personal
        }
      }
    );
    if (!citas) {
      logger.error('Agendamiento no encontrada por su asociacion con Sede y Odontologo');
      return res.status(404).json({ error: 'Agendamientos no encontrada' });
    }
    logger.info('Agendamientos obtenidas correctamente por su asociacion con Sede y Odontologo');
    res.json(citas);
  } catch (error) {
    logger.error('Error al obtener Agendamientos por Sede y Odontologo: ' + error.message);
    res.status(500).json({ error: 'Error al obtener Agendamientos' });
  }
};

// Obtener las citas por sede y personal (odontologo)
exports.getAgendamientoByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const citas = await Agendamiento.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!citas) {
      logger.error('Agendamiento no encontrado por su asociacion con Paciente');
      return res.status(404).json({ error: 'Agendamientos no encontrada' });
    }
    logger.info('Agendamientos obtenidas correctamente por su asociacion con el Paciente');
    res.json(citas);
  } catch (error) {
    logger.error('Error al obtener Agendamientos por Paciente: ' + error.message);
    res.status(500).json({ error: 'Error al obtener Agendamientos' });
  }
};

// Obtener una Agendamiento por ID
exports.getAgendamientoById = async (req, res) => {
  try {
    const cita = await Agendamiento.findByPk(req.params.id);
    if (!cita) {
      logger.error('Agendamiento no encontrada por su ID');
      return res.status(404).json({ error: 'Agendamiento no encontrada' });
    }
    logger.info('Agendamiento obtenido correctamente por su ID');
    res.json(cita);
  } catch (error) {
    logger.error('Error al obtener el Agendamiento mediante su Id: ' + error.message);
    res.status(500).json({ error: 'Error al obtener Agendamiento' });
  }
};

// Crear una Agendamiento
exports.createAgendamiento = async (req, res) => {
  try {
    const cita = await Agendamiento.create(req.body);
    logger.info('Agendamientos creado correctamente');
    res.status(201).json(cita);
  } catch (error) {
    logger.error('Error al crear un Agendamiento: ' + error.message);
    res.status(500).json({ error: 'Error al crear Agendamiento' });
  }
};

// Actualizar una Agendamiento
exports.updateAgendamiento = async (req, res) => {
  try {
    const cita = await Agendamiento.findByPk(req.params.id);
    if (!cita) {
      logger.error('Agendamiento no encontrada por su ID');
      return res.status(404).json({ error: 'Agendamiento no encontrada' });
    }
    await cita.update(req.body);
    logger.info('Agendamientos actualizado correctamente');
    res.json(cita);
  } catch (error) {
    logger.error('Error al actualizar un Agendamiento: ' + error.message);
    res.status(500).json({ error: 'Error al actualizar Agendamiento' });
  }
};

// Eliminar una Agendamiento
exports.deleteAgendamiento = async (req, res) => {
  try {
    const cita = await Agendamiento.findByPk(req.params.id);
    if (!cita) {
      logger.error('Agendamiento no encontrada por su ID');
      return res.status(404).json({ error: 'Agendamiento no encontrada' });
    }
    await cita.destroy();
    logger.info('Agendamientos eliminado correctamente');
    res.json({ message: 'Agendamiento eliminada' });
  } catch (error) {
    logger.error('Error al elimininar un Agendamiento: ' + error.message);
    res.status(500).json({ error: 'Error al eliminar Agendamiento' });
  }
};

