const {Almacen} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Almacenes
exports.getAlmacenAll = async (req, res) => {
  try {
    const almacenes = await Almacen.findAll();
    logger.info("Almacens obtenidos correctamente");
    res.json(almacenes);
  } catch (error) {
    logger.error("Error al obtener Almacens: " + error.message);
    res.status(500).json({ error: "Error al obtener Almacenes" });
  }
};

// Obtener todas las Almacenes de la sede
exports.getAlmacenBySede = async (req, res) => {
  try {
    const {sede} = req.params;
    const almacenes = await Almacen.findAll(
      {
        where: {
          SedeId: sede
        }
      }
    );
    logger.info("Almacens obtenidos correctamente");
    res.json(almacenes);
  } catch (error) {
    logger.error("Error al obtener Almacens: " + error.message);
    res.status(500).json({ error: "Error al obtener Almacenes" });
  }
};

// Obtener todas las Almacenes de la sede
exports.getAlmacenByResponsable = async (req, res) => {
  try {
    const {responsable} = req.params;
    const almacen = await Almacen.findOne(
      {
        where: {
          ResponsableId: responsable
        }
      }
    );
    logger.info("Almacen obtenidos correctamente");
    res.json(almacen);
  } catch (error) {
    logger.error("Error al obtener Almacen: " + error.message);
    res.status(500).json({ error: "Error al obtener Almacen" });
  }
};

// Obtener una Almacen por ID
exports.getAlmacenById = async (req, res) => {
  try {
    const almacen = await Almacen.findByPk(req.params.id);
    if (!almacen) {
      logger.error("Almacen no encontrada por su ID");
      return res.status(404).json({ error: "Almacen no encontrada" });
    }
    logger.info("Almacen obtenido correctamente por su ID");
    res.json(almacen);
  } catch (error) {
    logger.error("Error al obtener el Almacen mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Almacen" });
  }
};

// Crear una Almacen
exports.createAlmacen = async (req, res) => {
  try {
    const almacen = await Almacen.create(req.body);
    logger.info("Almacens creado correctamente");
    res.status(201).json(almacen);
  } catch (error) {
    logger.error("Error al crear un Almacen: " + error.message);
    res.status(500).json({ error: "Error al crear Almacen" });
  }
};

// Actualizar una Almacen
exports.updateAlmacen = async (req, res) => {
  try {
    const almacen = await Almacen.findByPk(req.params.id);
    if (!almacen) {
      logger.error("Almacen no encontrada por su ID");
      return res.status(404).json({ error: "Almacen no encontrada" });
    }
    await almacen.update(req.body);
    logger.info("Almacens actualizado correctamente");
    res.json(almacen);
  } catch (error) {
    logger.error("Error al actualizar un Almacen: " + error.message);
    res.status(500).json({ error: "Error al actualizar Almacen" });
  }
};

// Eliminar una Almacen
exports.deleteAlmacen = async (req, res) => {
  try {
    const almacen = await Almacen.findByPk(req.params.id);
    if (!almacen) {
      logger.error("Almacen no encontrada por su ID");
      return res.status(404).json({ error: "Almacen no encontrada" });
    }
    await Almacen.destroy();
    logger.info("Almacens eliminado correctamente");
    res.json({ message: "Almacen eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Almacen: " + error.message);
    res.status(500).json({ error: "Error al eliminar Almacen" });
  }
};

