const {Anotacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Anotaciones
exports.getAnotacionAll = async (req, res) => {
  try {
    const datos = await Anotacion.findAll();
    logger.info("Anotacions obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Anotacions: " + error.message);
    res.status(500).json({ error: "Error al obtener Anotaciones" });
  }
};

// Obtener Anotacion por Odontograma
exports.getAnotacionByOdontograma = async (req, res) => {
  try {
    const { odontograma } = req.params;
    const datos = await Anotacion.findAll(
      {
        where: {
          OdontogramaId: odontograma
        }
      }
    );
    if (datos.lenghth === 0) {
      logger.error("Anotacion no encontrada por su asociacion con Odontograma");
      res.json(null);
    }
    logger.info("Anotacions obtenidas correctamente por su asociacion con la Odontograma");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el Anotacion mediante por Odontograma: " + error.message);
    res.status(500).json({ error: "Error al obtener Anotacions" });
  }
};

// Obtener una Anotacion por ID
exports.getAnotacionById = async (req, res) => {
  try {
    const dato = await Anotacion.findByPk(req.params.id);
    if (!dato) {
      logger.error("Anotacion no encontrada por su ID");
      return res.status(404).json({ error: "Anotacion no encontrada" });
    }
    logger.info("Anotacion obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Anotacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Anotacion" });
  }
};

// Crear una Anotacion
exports.createAnotacion = async (req, res) => {
  try {
    const dato = await Anotacion.create(req.body);
    logger.info("Anotacions creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Anotacion: " + error.message);
    res.status(500).json({ error: "Error al crear Anotacion" });
  }
};

// Actualizar una Anotacion
exports.updateAnotacion = async (req, res) => {
  try {
    const dato = await Anotacion.findByPk(req.params.id);
    if (!dato) {
      logger.error("Anotacion no encontrada por su ID");
      return res.status(404).json({ error: "Anotacion no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Anotacions actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Anotacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Anotacion" });
  }
};

// Eliminar una Anotacion
exports.deleteAnotacion = async (req, res) => {
  try {
    const dato = await Anotacion.findByPk(req.params.id);
    if (!dato) {
      logger.error("Anotacion no encontrada por su ID");
      return res.status(404).json({ error: "Anotacion no encontrada" });
    }
    await Anotacion.destroy();
    logger.info("Anotacions eliminado correctamente");
    res.json({ message: "Anotacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Anotacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Anotacion" });
  }
};

