const {CargoUsuario} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las CargoUsuarioes
exports.getCargoUsuarioAll = async (req, res) => {
  try {
    const cargosusuario = await CargoUsuario.findAll();
    logger.info("Cargos Usuario obtenidos correctamente");
    res.json(cargosusuario);
  } catch (error) {
    logger.error("Error al obtener Cargos Usuario: " + error.message);
    res.status(500).json({ error: "Error al obtener Cargos Usuario" });
  }
};

// Obtener una Cargo Usuario por ID
exports.getCargoUsuarioById = async (req, res) => {
  try {
    const cargousuario = await CargoUsuario.findByPk(req.params.id);
    if (!cargousuario) {
      logger.error("Cargo Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Cargo Usuario no encontrada" });
    }
    logger.info("Cargo Usuario obtenido correctamente por su ID");
    res.json(cargousuario);
  } catch (error) {
    logger.error("Error al obtener el Cargo Usuario mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Cargo Usuario" });
  }
};

// Crear una Cargo Usuario
exports.createCargoUsuario = async (req, res) => {
  try {
    const cargousuario = await CargoUsuario.create(req.body);
    logger.info("Cargo Usuario creado correctamente");
    res.status(201).json(cargousuario);
  } catch (error) {
    logger.error("Error al crear un Cargo Usuario: " + error.message);
    res.status(500).json({ error: "Error al crear Cargo Usuario" });
  }
};

// Actualizar una Cargo Usuario
exports.updateCargoUsuario = async (req, res) => {
  try {
    const cargousuario = await CargoUsuario.findByPk(req.params.id);
    if (!cargousuario) {
      logger.error("Cargo Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Cargo Usuario no encontrada" });
    }
    await CargoUsuario.update(req.body);
    logger.info("Cargo Usuario actualizado correctamente");
    res.json(cargousuario);
  } catch (error) {
    logger.error("Error al actualizar un Cargo Usuario: " + error.message);
    res.status(500).json({ error: "Error al actualizar Cargo Usuario" });
  }
};

// Eliminar una Cargo Usuario
exports.deleteCargoUsuario = async (req, res) => {
  try {
    const cargousuario = await CargoUsuario.findByPk(req.params.id);
    if (!cargousuario) {
      logger.error("Cargo Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Cargo Usuario no encontrada" });
    }
    await cargousuario.destroy();
    logger.info("Cargo Usuario eliminado correctamente");
    res.json({ message: "Cargo Usuario eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Cargo Usuario: " + error.message);
    res.status(500).json({ error: "Error al eliminar Cargo Usuario" });
  }
};

