const { Catalogo, Hallazgo } = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Catalogoes
exports.getCatalogoAll = async (req, res) => {
  try {
    const items = await Catalogo.findAll(
      {
        include: [
          {
            model: Hallazgo,
            as: "hallazgo",
          }
        ],
      }
    );
    logger.info("Catalogos obtenidos correctamente");
    res.json(items);
  } catch (error) {
    logger.error("Error al obtener Catalogos: " + error.message);
    res.status(500).json({ error: "Error al obtener Catalogoes" });
  }
};

// Obtener una Catalogo por ID
exports.getCatalogoById = async (req, res) => {
  try {
    const item = await Catalogo.findByPk(req.params.id,
      {
        include: [
          {
            model: Hallazgo,
            as: "hallazgo",
          }
        ],
      }
      // req.params.id
    );
    if (!item) {
      logger.error("Catalogo no encontrada por su ID");
      return res.status(404).json({ error: "Catalogo no encontrada" });
    }
    logger.info("Catalogo obtenido correctamente por su ID");
    res.json(item);
  } catch (error) {
    logger.error("Error al obtener el Catalogo mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Catalogo" });
  }
};

// Crear una Catalogo
exports.createCatalogo = async (req, res) => {
  try {
    const item = await Catalogo.create(req.body);
    logger.info("Catalogos creado correctamente");
    res.status(201).json(item);
  } catch (error) {
    logger.error("Error al crear un Catalogo: " + error.message);
    res.status(500).json({ error: "Error al crear Catalogo" });
  }
};

// Actualizar una Catalogo
exports.updateCatalogo = async (req, res) => {
  try {
    const item = await Catalogo.findByPk(req.params.id);
    if (!item) {
      logger.error("Catalogo no encontrada por su ID");
      return res.status(404).json({ error: "Catalogo no encontrada" });
    }
    await item.update(req.body);
    logger.info("Catalogos actualizado correctamente");
    res.json(item);
  } catch (error) {
    logger.error("Error al actualizar un Catalogo: " + error.message);
    res.status(500).json({ error: "Error al actualizar Catalogo" });
  }
};

// Eliminar una Catalogo
exports.deleteCatalogo = async (req, res) => {
  try {
    const item = await Catalogo.findByPk(req.params.id);
    if (!item) {
      logger.error("Catalogo no encontrada por su ID");
      return res.status(404).json({ error: "Catalogo no encontrada" });
    }
    await Catalogo.destroy();
    logger.info("Catalogos eliminado correctamente");
    res.json({ message: "Catalogo eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Catalogo: " + error.message);
    res.status(500).json({ error: "Error al eliminar Catalogo" });
  }
};
