const {Categoria} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Categoriaes
exports.getCategoriaAll = async (req, res) => {
  try {
    const categorias = await Categoria.findAll();
    logger.info("Categorias obtenidos correctamente");
    res.json(categorias);
  } catch (error) {
    logger.error("Error al obtener Categorias: " + error.message);
    res.status(500).json({ error: "Error al obtener Categoriaes" });
  }
};

// Obtener una Categoria por ID
exports.getCategoriaById = async (req, res) => {
  try {
    const categoria = await Categoria.findByPk(req.params.id);
    if (!categoria) {
      logger.error("Categoria no encontrada por su ID");
      return res.status(404).json({ error: "Categoria no encontrada" });
    }
    logger.info("Categoria obtenido correctamente por su ID");
    res.json(categoria);
  } catch (error) {
    logger.error("Error al obtener el Categoria mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Categoria" });
  }
};

// Crear una Categoria
exports.createCategoria = async (req, res) => {
  try {
    const categoria = await Categoria.create(req.body);
    logger.info("Categorias creado correctamente");
    res.status(201).json(categoria);
  } catch (error) {
    logger.error("Error al crear un Categoria: " + error.message);
    res.status(500).json({ error: "Error al crear Categoria" });
  }
};

// Actualizar una Categoria
exports.updateCategoria = async (req, res) => {
  try {
    const categoria = await Categoria.findByPk(req.params.id);
    if (!categoria) {
      logger.error("Categoria no encontrada por su ID");
      return res.status(404).json({ error: "Categoria no encontrada" });
    }
    await categoria.update(req.body);
    logger.info("Categorias actualizado correctamente");
    res.json(categoria);
  } catch (error) {
    logger.error("Error al actualizar un Categoria: " + error.message);
    res.status(500).json({ error: "Error al actualizar Categoria" });
  }
};

// Eliminar una Categoria
exports.deleteCategoria = async (req, res) => {
  try {
    const categoria = await Categoria.findByPk(req.params.id);
    if (!categoria) {
      logger.error("Categoria no encontrada por su ID");
      return res.status(404).json({ error: "Categoria no encontrada" });
    }
    await Categoria.destroy();
    logger.info("Categorias eliminado correctamente");
    res.json({ message: "Categoria eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Categoria: " + error.message);
    res.status(500).json({ error: "Error al eliminar Categoria" });
  }
};

