const {CategoriaInventario} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las CategoriaInventarioes
exports.getCategoriaInventarioAll = async (req, res) => {
  try {
    const categorias = await CategoriaInventario.findAll();
    logger.info("CategoriaInventarios obtenidos correctamente");
    res.json(categorias);
  } catch (error) {
    logger.error("Error al obtener CategoriaInventarios: " + error.message);
    res.status(500).json({ error: "Error al obtener CategoriaInventarioes" });
  }
};

// Obtener una CategoriaInventario por ID
exports.getCategoriaInventarioById = async (req, res) => {
  try {
    const categoria = await CategoriaInventario.findByPk(req.params.id);
    if (!categoria) {
      logger.error("CategoriaInventario no encontrada por su ID");
      return res.status(404).json({ error: "CategoriaInventario no encontrada" });
    }
    logger.info("CategoriaInventario obtenido correctamente por su ID");
    res.json(categoria);
  } catch (error) {
    logger.error("Error al obtener el CategoriaInventario mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener CategoriaInventario" });
  }
};

// Crear una CategoriaInventario
exports.createCategoriaInventario = async (req, res) => {
  try {
    const categoria = await CategoriaInventario.create(req.body);
    logger.info("CategoriaInventarios creado correctamente");
    res.status(201).json(categoria);
  } catch (error) {
    logger.error("Error al crear un CategoriaInventario: " + error.message);
    res.status(500).json({ error: "Error al crear CategoriaInventario" });
  }
};

// Actualizar una CategoriaInventario
exports.updateCategoriaInventario = async (req, res) => {
  try {
    const categoria = await CategoriaInventario.findByPk(req.params.id);
    if (!categoria) {
      logger.error("CategoriaInventario no encontrada por su ID");
      return res.status(404).json({ error: "CategoriaInventario no encontrada" });
    }
    await categoria.update(req.body);
    logger.info("CategoriaInventarios actualizado correctamente");
    res.json(categoria);
  } catch (error) {
    logger.error("Error al actualizar un CategoriaInventario: " + error.message);
    res.status(500).json({ error: "Error al actualizar CategoriaInventario" });
  }
};

// Eliminar una CategoriaInventario
exports.deleteCategoriaInventario = async (req, res) => {
  try {
    const categoria = await CategoriaInventario.findByPk(req.params.id);
    if (!categoria) {
      logger.error("CategoriaInventario no encontrada por su ID");
      return res.status(404).json({ error: "CategoriaInventario no encontrada" });
    }
    await CategoriaInventario.destroy();
    logger.info("CategoriaInventarios eliminado correctamente");
    res.json({ message: "CategoriaInventario eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un CategoriaInventario: " + error.message);
    res.status(500).json({ error: "Error al eliminar CategoriaInventario" });
  }
};

