const {CategoriaPatrimonio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las CategoriaPatrimonioes
exports.getCategoriaPatrimonioAll = async (req, res) => {
  try {
    const categorias = await CategoriaPatrimonio.findAll();
    logger.info("CategoriaPatrimonios obtenidos correctamente");
    res.json(categorias);
  } catch (error) {
    logger.error("Error al obtener CategoriaPatrimonios: " + error.message);
    res.status(500).json({ error: "Error al obtener CategoriaPatrimonioes" });
  }
};

// Obtener una CategoriaPatrimonio por ID
exports.getCategoriaPatrimonioById = async (req, res) => {
  try {
    const categoria = await CategoriaPatrimonio.findByPk(req.params.id);
    if (!categoria) {
      logger.error("CategoriaPatrimonio no encontrada por su ID");
      return res.status(404).json({ error: "CategoriaPatrimonio no encontrada" });
    }
    logger.info("CategoriaPatrimonio obtenido correctamente por su ID");
    res.json(categoria);
  } catch (error) {
    logger.error("Error al obtener el CategoriaPatrimonio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener CategoriaPatrimonio" });
  }
};

// Crear una CategoriaPatrimonio
exports.createCategoriaPatrimonio = async (req, res) => {
  try {
    const categoria = await CategoriaPatrimonio.create(req.body);
    logger.info("CategoriaPatrimonios creado correctamente");
    res.status(201).json(categoria);
  } catch (error) {
    logger.error("Error al crear un CategoriaPatrimonio: " + error.message);
    res.status(500).json({ error: "Error al crear CategoriaPatrimonio" });
  }
};

// Actualizar una CategoriaPatrimonio
exports.updateCategoriaPatrimonio = async (req, res) => {
  try {
    const categoria = await CategoriaPatrimonio.findByPk(req.params.id);
    if (!categoria) {
      logger.error("CategoriaPatrimonio no encontrada por su ID");
      return res.status(404).json({ error: "CategoriaPatrimonio no encontrada" });
    }
    await categoria.update(req.body);
    logger.info("CategoriaPatrimonios actualizado correctamente");
    res.json(categoria);
  } catch (error) {
    logger.error("Error al actualizar un CategoriaPatrimonio: " + error.message);
    res.status(500).json({ error: "Error al actualizar CategoriaPatrimonio" });
  }
};

// Eliminar una CategoriaPatrimonio
exports.deleteCategoriaPatrimonio = async (req, res) => {
  try {
    const categoria = await CategoriaPatrimonio.findByPk(req.params.id);
    if (!categoria) {
      logger.error("CategoriaPatrimonio no encontrada por su ID");
      return res.status(404).json({ error: "CategoriaPatrimonio no encontrada" });
    }
    await CategoriaPatrimonio.destroy();
    logger.info("CategoriaPatrimonios eliminado correctamente");
    res.json({ message: "CategoriaPatrimonio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un CategoriaPatrimonio: " + error.message);
    res.status(500).json({ error: "Error al eliminar CategoriaPatrimonio" });
  }
};

