const {Cliente} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Clientees
exports.getClienteAll = async (req, res) => {
  try {
    const clientes = await Cliente.findAll();
    logger.info("Clientes obtenidos correctamente");
    res.json(clientes);
  } catch (error) {
    logger.error("Error al obtener Clientes: " + error.message);
    res.status(500).json({ error: "Error al obtener Clientees" });
  }
};

// Obtener una Cliente por Documento
exports.getClienteByDocumento = async (req, res) => {
  try {
    const { documento } = req.params;
    const cliente = await Cliente.findOne(
      {
        where: { NumeroDocumento: documento }
      }
    );
    if (!cliente) {
      logger.error("Cliente no encontrada por su Documento");
      return res.json(null);
    }
    logger.info("Cliente obtenido correctamente por su ID");
    res.json(cliente);
  } catch (error) {
    logger.error("Error al obtener el Cliente mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Cliente" });
  }
};

// Obtener una Cliente por ID
exports.getClienteById = async (req, res) => {
  try {
    const cliente = await Cliente.findByPk(req.params.id);
    if (!cliente) {
      logger.error("Cliente no encontrada por su ID");
      return res.status(404).json({ error: "Cliente no encontrada" });
    }
    logger.info("Cliente obtenido correctamente por su ID");
    res.json(cliente);
  } catch (error) {
    logger.error("Error al obtener el Cliente mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Cliente" });
  }
};

// Crear una Cliente
exports.createCliente = async (req, res) => {
  try {
    const cliente = await Cliente.create(req.body);
    logger.info("Cliente creado correctamente");
    res.status(201).json(cliente);
  } catch (error) {
    logger.error("Error al crear un Cliente: " + error.message);
    res.status(500).json({ error: "Error al crear Cliente" });
  }
};

// Actualizar una Cliente
exports.updateCliente = async (req, res) => {
  try {
    const cliente = await Cliente.findByPk(req.params.id);
    if (!cliente) {
      logger.error("Cliente no encontrada por su ID");
      return res.status(404).json({ error: "Cliente no encontrada" });
    }
    await cliente.update(req.body);
    logger.info("Cliente actualizado correctamente");
    res.json(cliente);
  } catch (error) {
    logger.error("Error al actualizar un Cliente: " + error.message);
    res.status(500).json({ error: "Error al actualizar Cliente" });
  }
};

// Eliminar una Cliente
exports.deleteCliente = async (req, res) => {
  try {
    const cliente = await Cliente.findByPk(req.params.id);
    if (!cliente) {
      logger.error("Cliente no encontrada por su ID");
      return res.status(404).json({ error: "Cliente no encontrada" });
    }
    await Cliente.destroy();
    logger.info("Cliente eliminado correctamente");
    res.json({ message: "Cliente eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Cliente: " + error.message);
    res.status(500).json({ error: "Error al eliminar Cliente" });
  }
};

