const {Consultorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Consultorioes
exports.getConsultorioAll = async (req, res) => {
  try {
    const consultorios = await Consultorio.findAll();
    logger.info("Consultorios obtenidos correctamente");
    res.json(consultorios);
  } catch (error) {
    logger.error("Error al obtener Consultorios: " + error.message);
    res.status(500).json({ error: "Error al obtener Consultorioes" });
  }
};

// Obtener Consultorios por Sede
exports.getConsultorioBySede = async (req, res) => {
  try {
    const { sede } = req.params;
    const consultorios = await Consultorio.findAll(
      {
        where: {
          SedeId: sede
        }
      }
    );
    if (!consultorios) {
      logger.error("Consultorios no encontrados por su Sede");
      return res.status(404).json({ error: "Consultorios no encontrados" });
    }
    logger.info("Consultorios obtenidos correctamente por su Sede");
    res.json(consultorios);
  } catch (error) {
    logger.error("Error al obtener el Consultorios mediante su Sede: " + error.message);
    res.status(500).json({ error: "Error al obtener Consultorios" });
  }
};

// Obtener una Consultorio por ID
exports.getConsultorioById = async (req, res) => {
  try {
    const consultorio = await Consultorio.findByPk(req.params.id);
    if (!consultorio) {
      logger.error("Consultorio no encontrada por su ID");
      return res.status(404).json({ error: "Consultorio no encontrada" });
    }
    logger.info("Consultorio obtenido correctamente por su ID");
    res.json(consultorio);
  } catch (error) {
    logger.error("Error al obtener el Consultorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Consultorio" });
  }
};

// Crear una Consultorio
exports.createConsultorio = async (req, res) => {
  try {
    const consultorio = await Consultorio.create(req.body);
    logger.info("Consultorios creado correctamente");
    res.status(201).json(consultorio);
  } catch (error) {
    logger.error("Error al crear un Consultorio: " + error.message);
    res.status(500).json({ error: "Error al crear Consultorio" });
  }
};

// Actualizar una Consultorio
exports.updateConsultorio = async (req, res) => {
  try {
    const consultorio = await Consultorio.findByPk(req.params.id);
    if (!consultorio) {
      logger.error("Consultorio no encontrada por su ID");
      return res.status(404).json({ error: "Consultorio no encontrada" });
    }
    await consultorio.update(req.body);
    logger.info("Consultorios actualizado correctamente");
    res.json(consultorio);
  } catch (error) {
    logger.error("Error al actualizar un Consultorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar Consultorio" });
  }
};

// Eliminar una Consultorio
exports.deleteConsultorio = async (req, res) => {
  try {
    const consultorio = await Consultorio.findByPk(req.params.id);
    if (!consultorio) {
      logger.error("Consultorio no encontrada por su ID");
      return res.status(404).json({ error: "Consultorio no encontrada" });
    }
    await Consultorio.destroy();
    logger.info("Consultorios eliminado correctamente");
    res.json({ message: "Consultorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Consultorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar Consultorio" });
  }
};

