const {Cronologia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Cronologiaes
exports.getCronologiaAll = async (req, res) => {
  try {
    const datos = await Cronologia.findAll();
    logger.info("Cronologias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Cronologias: " + error.message);
    res.status(500).json({ error: "Error al obtener Cronologiaes" });
  }
};

// Obtener Cronologia por Historia Clinica
exports.getCronologiaByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await Cronologia.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!datos) {
      logger.error("Cronologia no encontrada por su asociacion con Diente");
      return res.status(404).json({ error: "Cronologias no encontrada" });
    }
    logger.info("Cronologias obtenidas correctamente por su asociacion con la Diente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el Cronologia mediante por Diente: " + error.message);
    res.status(500).json({ error: "Error al obtener Cronologias" });
  }
};

// Obtener una Cronologia por ID
exports.getCronologiaById = async (req, res) => {
  try {
    const dato = await Cronologia.findByPk(req.params.id);
    if (!dato) {
      logger.error("Cronologia no encontrada por su ID");
      return res.status(404).json({ error: "Cronologia no encontrada" });
    }
    logger.info("Cronologia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Cronologia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Cronologia" });
  }
};

// Crear una Cronologia
exports.createCronologia = async (req, res) => {
  try {
    const dato = await Cronologia.create(req.body);
    logger.info("Cronologias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Cronologia: " + error.message);
    res.status(500).json({ error: "Error al crear Cronologia" });
  }
};

// Actualizar una Cronologia
exports.updateCronologia = async (req, res) => {
  try {
    const dato = await Cronologia.findByPk(req.params.id);
    if (!dato) {
      logger.error("Cronologia no encontrada por su ID");
      return res.status(404).json({ error: "Cronologia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Cronologias actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Cronologia: " + error.message);
    res.status(500).json({ error: "Error al actualizar Cronologia" });
  }
};

// Eliminar una Cronologia
exports.deleteCronologia = async (req, res) => {
  try {
    const dato = await Cronologia.findByPk(req.params.id);
    if (!dato) {
      logger.error("Cronologia no encontrada por su ID");
      return res.status(404).json({ error: "Cronologia no encontrada" });
    }
    await Cronologia.destroy();
    logger.info("Cronologias eliminado correctamente");
    res.json({ message: "Cronologia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Cronologia: " + error.message);
    res.status(500).json({ error: "Error al eliminar Cronologia" });
  }
};

