const {Cuadrante} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Cuadrantees
exports.getCuadranteAll = async (req, res) => {
  try {
    const cuadrantes = await Cuadrante.findAll();
    logger.info("Cuadrantes obtenidos correctamente");
    res.json(cuadrantes);
  } catch (error) {
    logger.error("Error al obtener Cuadrantes: " + error.message);
    res.status(500).json({ error: "Error al obtener Cuadrantees" });
  }
};

// Obtener una Cuadrante por ID
exports.getCuadranteById = async (req, res) => {
  try {
    const cuadrante = await Cuadrante.findByPk(req.params.id);
    if (!cuadrante) {
      logger.error("Cuadrante no encontrada por su ID");
      return res.status(404).json({ error: "Cuadrante no encontrada" });
    }
    logger.info("Cuadrante obtenido correctamente por su ID");
    res.json(cuadrante);
  } catch (error) {
    logger.error("Error al obtener el Cuadrante mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Cuadrante" });
  }
};

// Crear una Cuadrante
exports.createCuadrante = async (req, res) => {
  try {
    const cuadrante = await Cuadrante.create(req.body);
    logger.info("Cuadrantes creado correctamente");
    res.status(201).json(cuadrante);
  } catch (error) {
    logger.error("Error al crear un Cuadrante: " + error.message);
    res.status(500).json({ error: "Error al crear Cuadrante" });
  }
};

// Actualizar una Cuadrante
exports.updateCuadrante = async (req, res) => {
  try {
    const cuadrante = await Cuadrante.findByPk(req.params.id);
    if (!cuadrante) {
      logger.error("Cuadrante no encontrada por su ID");
      return res.status(404).json({ error: "Cuadrante no encontrada" });
    }
    await cuadrante.update(req.body);
    logger.info("Cuadrante actualizado correctamente");
    res.json(cuadrante);
  } catch (error) {
    logger.error("Error al actualizar un Cuadrante: " + error.message);
    res.status(500).json({ error: "Error al actualizar Cuadrante" });
  }
};

// Eliminar una Cuadrante
exports.deleteCuadrante = async (req, res) => {
  try {
    const cuadrante = await Cuadrante.findByPk(req.params.id);
    if (!cuadrante) {
      logger.error("Cuadrante no encontrada por su ID");
      return res.status(404).json({ error: "Cuadrante no encontrada" });
    }
    await Cuadrante.destroy();
    logger.info("Cuadrante eliminado correctamente");
    res.json({ message: "Cuadrante eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Cuadrante: " + error.message);
    res.status(500).json({ error: "Error al eliminar Cuadrante" });
  }
};

