const {
  // para la incidencia
  EstadoIncidencia, TipoIncidencia,
  // para agendamiento
  EstadoAgendamiento, EstadoPago, TipoPago,
  // para paciente y usuario
  Genero, TipoDocumento, 
  // para paciente
  GradoInstruccion, TipoAfiliacion, FuenteCaptacion, 
  // para usuario
  EstadoUsuario, Vinculacion, TipoUsuario, 
  CargoUsuario, Profesion, Sede, Servicio
} = require("../models");

// Obtener datos para incidencia
exports.getincidenciaData = async (req, res) => {
  try {
    const estados = await EstadoIncidencia.findAll();
    const tipos = await TipoIncidencia.findAll();
    logger.info("Datos genericos para la Incidencia -> obtenidos correctamente");
    res.json(
      {
        estados: estados,
        tipos: tipos
      }
    );
  } catch (error) {
    logger.error("Error al obtener datos para la Incidencia: " + error.message);
    res.status(500).json({ error: "Error al obtener datos para la Incidencia" });
  }
};

// Obtener datos para agendamiento
exports.getagendamientoData = async (req, res) => {
  try {
    const estadosagendamiento = await EstadoAgendamiento.findAll();
    const estadospago = await EstadoPago.findAll();
    const tipospago = await TipoPago.findAll();
    logger.info("Datos genericos para el agendamiento -> obtenidos correctamente");
    res.json(
      {
        estadosagendamiento: estadosagendamiento,
        estadospago: estadospago,
        tipospago: tipospago
      }
    );
  } catch (error) {
    logger.error("Error al obtener datos para el agendamiento: " + error.message);
    res.status(500).json({ error: "Error al obtener datos para el agendamiento" });
  }
};

// Obtener datos para pacientes
exports.getpacienteData = async (req, res) => {
  try {
    const generos = await Genero.findAll();
    const tiposdoc = await TipoDocumento.findAll();
    const grados = await GradoInstruccion.findAll();
    const tiposafi = await TipoAfiliacion.findAll();
    const fuentes = await FuenteCaptacion.findAll();
    const sedes = await Sede.findAll();
    logger.info("Datos genericos para el paciente -> obtenidos correctamente");
    res.json(
      {
        generos: generos,
        tiposdoc: tiposdoc,
        grados: grados,
        tiposafi: tiposafi,
        fuentes: fuentes,
        sedes: sedes
      }
    );
  } catch (error) {
    logger.error("Error al obtener datos para el paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener datos para el paciente" });
  }
};
// para usuario
EstadoUsuario, Vinculacion, TipoUsuario, 
CargoUsuario, Profesion, Servicio
// Obtener datos para usuarios
exports.getusuarioData = async (req, res) => {
  try {
    const generos = await Genero.findAll();
    const tiposdoc = await TipoDocumento.findAll();
    const estados = await EstadoUsuario.findAll();
    const vinculaciones = await Vinculacion.findAll();
    const tiposusuario = await TipoUsuario.findAll();
    const cargos = await CargoUsuario.findAll();
    const profesiones = await Profesion.findAll();
    const servicios = await Servicio.findAll();
    const sedes = await Sede.findAll();
    logger.info("Datos genericos para el usuario -> obtenidos correctamente");
    res.json(
      {
        generos: generos,
        tiposdoc: tiposdoc,
        estados: estados,
        vinculaciones: vinculaciones,
        tiposusuario: tiposusuario,
        cargos: cargos,
        profesiones: profesiones,
        servicios: servicios,
        sedes: sedes
      }
    );
  } catch (error) {
    logger.error("Error al obtener datos para el usuario: " + error.message);
    res.status(500).json({ error: "Error al obtener datos para el usuario" });
  }
};

// Obtener datos para economia
exports.geteconomiaData = async (req, res) => {
  try {
    const tiposingreso = await TipoIngreso.findAll();
    const tipospago = await TipoPago.findAll();
    const tiposproveedor = await TipoProveedor.findAll();
    const estadospago = await EstadoPago.findAll();
    logger.info("Datos genericos para la Economia -> obtenidos correctamente");
    res.json(
      {
        tiposingreso: tiposingreso,
        tipospago: tipospago,
        tiposproveedor: tiposproveedor,
        estadospago: estadospago
      }
    );
  } catch (error) {
    logger.error("Error al obtener datos para la Economia: " + error.message);
    res.status(500).json({ error: "Error al obtener datos para la Economia" });
  }
};

// Obtener datos para campania
exports.getcampaniaData = async (req, res) => {
  try {
    const estadoscampania = await EstadoCampania.findAll();
    const tiposactividad = await TipoActividad.findAll();
    const tiposcampania = await TipoCampania.findAll();
    const tiposrespuesta = await TipoRespuesta.findAll();
    const periodos = await Periodo.findAll();
    logger.info("Datos genericos para la Campania -> obtenidos correctamente");
    res.json(
      {
        estadoscampania: estadoscampania,
        tiposactividad: tiposactividad,
        tiposcampania: tiposcampania,
        tiposrespuesta: tiposrespuesta,
        periodos: periodos
      }
    );
  } catch (error) {
    logger.error("Error al obtener datos para la Campania: " + error.message);
    res.status(500).json({ error: "Error al obtener datos para la Campania" });
  }
};


// const {
//   // para la incidencia
//   EstadoIncidencia, TipoIncidencia,
//   // para agendamiento
//   EstadoAgendamiento, EstadoPago, TipoPago,
//   // para paciente y usuario
//   Genero, TipoDocumento, 
//   // para paciente
//   GradoInstruccion, TipoAfiliacion, FuenteCaptacion, 
//   // para usuario
//   EstadoUsuario, Vinculacion, TipoUsuario, 
//   CargoUsuario, Profesion, Sede, Servicio
// } = require("../models");

// // Obtener datos para incidencia
// exports.getincidenciaData = async (req, res) => {
//   try {
//     const estados = await EstadoIncidencia.findAll();
//     const tipos = await TipoIncidencia.findAll();
//     logger.info("Datos genericos para la Incidencia -> obtenidos correctamente");
//     res.json(
//       {
//         estados: estados,
//         tipos: tipos
//       }
//     );
//   } catch (error) {
//     logger.error("Error al obtener datos para la Incidencia: " + error.message);
//     res.status(500).json({ error: "Error al obtener datos para la Incidencia" });
//   }
// };

// // Obtener datos para agendamiento
// exports.getagendamientoData = async (req, res) => {
//   try {
//     const estadosagendamiento = await EstadoAgendamiento.findAll();
//     const estadospago = await EstadoPago.findAll();
//     const tipospago = await TipoPago.findAll();
//     logger.info("Datos genericos para el agendamiento -> obtenidos correctamente");
//     res.json(
//       {
//         estadosagendamiento: estadosagendamiento,
//         estadospago: estadospago,
//         tipospago: tipospago
//       }
//     );
//   } catch (error) {
//     logger.error("Error al obtener datos para el agendamiento: " + error.message);
//     res.status(500).json({ error: "Error al obtener datos para el agendamiento" });
//   }
// };

// // Obtener datos para pacientes
// exports.getpacienteData = async (req, res) => {
//   try {
//     const generos = await Genero.findAll();
//     const tiposdoc = await TipoDocumento.findAll();
//     const grados = await GradoInstruccion.findAll();
//     const tiposafi = await TipoAfiliacion.findAll();
//     const fuentes = await FuenteCaptacion.findAll();
//     const sedes = await Sede.findAll();
//     logger.info("Datos genericos para el paciente -> obtenidos correctamente");
//     res.json(
//       {
//         generos: generos,
//         tiposdoc: tiposdoc,
//         grados: grados,
//         tiposafi: tiposafi,
//         fuentes: fuentes,
//         sedes: sedes
//       }
//     );
//   } catch (error) {
//     logger.error("Error al obtener datos para el paciente: " + error.message);
//     res.status(500).json({ error: "Error al obtener datos para el paciente" });
//   }
// };
// // para usuario
// EstadoUsuario, Vinculacion, TipoUsuario, 
// CargoUsuario, Profesion, Servicio
// // Obtener datos para usuarios
// exports.getusuarioData = async (req, res) => {
//   try {
//     const generos = await Genero.findAll();
//     const tiposdoc = await TipoDocumento.findAll();
//     const estados = await EstadoUsuario.findAll();
//     const vinculaciones = await Vinculacion.findAll();
//     const tiposusuario = await TipoUsuario.findAll();
//     const cargos = await CargoUsuario.findAll();
//     const profesiones = await Profesion.findAll();
//     const servicios = await Servicio.findAll();
//     const sedes = await Sede.findAll();
//     logger.info("Datos genericos para el usuario -> obtenidos correctamente");
//     res.json(
//       {
//         generos: generos,
//         tiposdoc: tiposdoc,
//         estados: estados,
//         vinculaciones: vinculaciones,
//         tiposusuario: tiposusuario,
//         cargos: cargos,
//         profesiones: profesiones,
//         servicios: servicios,
//         sedes: sedes
//       }
//     );
//   } catch (error) {
//     logger.error("Error al obtener datos para el usuario: " + error.message);
//     res.status(500).json({ error: "Error al obtener datos para el usuario" });
//   }
// };



