const {Diagnostico} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Diagnosticoes
exports.getDiagnosticoAll = async (req, res) => {
  try {
    const diagnosticos = await Diagnostico.findAll();
    logger.info("Diagnosticos obtenidos correctamente");
    res.json(diagnosticos);
  } catch (error) {
    logger.error("Error al obtener Diagnosticos: " + error.message);
    res.status(500).json({ error: "Error al obtener Diagnosticoes" });
  }
};

// Obtener una Diagnostico por ID
exports.getDiagnosticoById = async (req, res) => {
  try {
    const diagnostico = await Diagnostico.findByPk(req.params.id);
    if (!diagnostico) {
      logger.error("Diagnostico no encontrada por su ID");
      return res.status(404).json({ error: "Diagnostico no encontrada" });
    }
    logger.info("Diagnostico obtenido correctamente por su ID");
    res.json(diagnostico);
  } catch (error) {
    logger.error("Error al obtener el Diagnostico mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Diagnostico" });
  }
};

// Crear una Diagnostico
exports.createDiagnostico = async (req, res) => {
  try {
    const diagnostico = await Diagnostico.create(req.body);
    logger.info("Diagnosticos creado correctamente");
    res.status(201).json(diagnostico);
  } catch (error) {
    logger.error("Error al crear un Diagnostico: " + error.message);
    res.status(500).json({ error: "Error al crear Diagnostico" });
  }
};

// Actualizar una Diagnostico
exports.updateDiagnostico = async (req, res) => {
  try {
    const diagnostico = await Diagnostico.findByPk(req.params.id);
    if (!diagnostico) {
      logger.error("Diagnostico no encontrada por su ID");
      return res.status(404).json({ error: "Diagnostico no encontrada" });
    }
    await diagnostico.update(req.body);
    logger.info("Diagnostico actualizado correctamente");
    res.json(diagnostico);
  } catch (error) {
    logger.error("Error al actualizar un Diagnostico: " + error.message);
    res.status(500).json({ error: "Error al actualizar Diagnostico" });
  }
};

// Eliminar una Diagnostico
exports.deleteDiagnostico = async (req, res) => {
  try {
    const diagnostico = await Diagnostico.findByPk(req.params.id);
    if (!diagnostico) {
      logger.error("Diagnostico no encontrada por su ID");
      return res.status(404).json({ error: "Diagnostico no encontrada" });
    }
    await Diagnostico.destroy();
    logger.info("Diagnostico eliminado correctamente");
    res.json({ message: "Diagnostico eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Diagnostico: " + error.message);
    res.status(500).json({ error: "Error al eliminar Diagnostico" });
  }
};

