const { Diente, TipoDiente, Ubicacion, Cuadrante } = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Dientees
exports.getDienteAll = async (req, res) => {
  try {
    const datos = await Diente.findAll(
      {
        include: [
          {
            model: TipoDiente,
            as: "tipo"
          },
          {
            model: Ubicacion,
            as: "ubicacion"
          },
          {
            model: Cuadrante,
            as: "cuadrante"
          }
        ]
      }
    );
    logger.info("Dientes obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Dientes: " + error.message);
    res.status(500).json({ error: "Error al obtener Dientees" });
  }
};

// Obtener una Diente por ID
exports.getDienteById = async (req, res) => {
  try {
    const dato = await Diente.findByPk(req.params.id);
    if (!dato) {
      logger.error("Diente no encontrada por su ID");
      return res.status(404).json({ error: "Diente no encontrada" });
    }
    logger.info("Diente obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Diente mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Diente" });
  }
};

// Crear una Diente
exports.createDiente = async (req, res) => {
  try {
    const dato = await Diente.create(req.body);
    logger.info("Dientes creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Diente: " + error.message);
    res.status(500).json({ error: "Error al crear Diente" });
  }
};

// Actualizar una Diente
exports.updateDiente = async (req, res) => {
  try {
    const dato = await Diente.findByPk(req.params.id);
    if (!dato) {
      logger.error("Diente no encontrada por su ID");
      return res.status(404).json({ error: "Diente no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Diente actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Diente: " + error.message);
    res.status(500).json({ error: "Error al actualizar Diente" });
  }
};

// Eliminar una Diente
exports.deleteDiente = async (req, res) => {
  try {
    const dato = await Diente.findByPk(req.params.id);
    if (!dato) {
      logger.error("Diente no encontrada por su ID");
      return res.status(404).json({ error: "Diente no encontrada" });
    }
    await Diente.destroy();
    logger.info("Diente eliminado correctamente");
    res.json({ message: "Diente eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Diente: " + error.message);
    res.status(500).json({ error: "Error al eliminar Diente" });
  }
};

