const {DienteClinico} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las DienteClinicoes
exports.getDienteClinicoAll = async (req, res) => {
  try {
    const datos = await DienteClinico.findAll();
    logger.info("DienteClinicos obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener DienteClinicos: " + error.message);
    res.status(500).json({ error: "Error al obtener DienteClinicoes" });
  }
};

// Obtener DienteClinico por Odontograma
exports.getDienteClinicoByOdontograma = async (req, res) => {
  try {
    const { odontograma } = req.params;
    const datos = await DienteClinico.findAll(
      {
        where: {
          OdontogramaId: odontograma
        }
      }
    );
    if (datos.lenghth === 0) {
      logger.error("DienteClinico no encontrada por su asociacion con Odontograma");
      res.json(null);
    }
    logger.info("DienteClinicos obtenidas correctamente por su asociacion con la Odontograma");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el DienteClinico mediante por Odontograma: " + error.message);
    res.status(500).json({ error: "Error al obtener DienteClinicos" });
  }
};

// Obtener una DienteClinico por ID
exports.getDienteClinicoById = async (req, res) => {
  try {
    const dato = await DienteClinico.findByPk(req.params.id);
    if (!dato) {
      logger.error("DienteClinico no encontrada por su ID");
      return res.status(404).json({ error: "DienteClinico no encontrada" });
    }
    logger.info("DienteClinico obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el DienteClinico mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener DienteClinico" });
  }
};

// Crear una DienteClinico
exports.createDienteClinico = async (req, res) => {
  try {
    const dato = await DienteClinico.create(req.body);
    logger.info("DienteClinicos creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un DienteClinico: " + error.message);
    res.status(500).json({ error: "Error al crear DienteClinico" });
  }
};

// Actualizar una DienteClinico
exports.updateDienteClinico = async (req, res) => {
  try {
    const dato = await DienteClinico.findByPk(req.params.id);
    if (!dato) {
      logger.error("DienteClinico no encontrada por su ID");
      return res.status(404).json({ error: "DienteClinico no encontrada" });
    }
    await dato.update(req.body);
    logger.info("DienteClinicos actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un DienteClinico: " + error.message);
    res.status(500).json({ error: "Error al actualizar DienteClinico" });
  }
};

// Eliminar una DienteClinico
exports.deleteDienteClinico = async (req, res) => {
  try {
    const dato = await DienteClinico.findByPk(req.params.id);
    if (!dato) {
      logger.error("DienteClinico no encontrada por su ID");
      return res.status(404).json({ error: "DienteClinico no encontrada" });
    }
    await DienteClinico.destroy();
    logger.info("DienteClinicos eliminado correctamente");
    res.json({ message: "DienteClinico eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un DienteClinico: " + error.message);
    res.status(500).json({ error: "Error al eliminar DienteClinico" });
  }
};

