const {DienteEconomico} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las DienteEconomicoes
exports.getDienteEconomicoAll = async (req, res) => {
  try {
    const datos = await DienteEconomico.findAll();
    logger.info("DienteEconomicos obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener DienteEconomicos: " + error.message);
    res.status(500).json({ error: "Error al obtener DienteEconomicoes" });
  }
};

// Obtener DienteEconomico por Odontograma
exports.getDienteEconomicoByOdontograma = async (req, res) => {
  try {
    const { odontograma } = req.params;
    const datos = await DienteEconomico.findAll(
      {
        where: {
          OdontogramaId: odontograma
        }
      }
    );
    if (datos.lenghth === 0) {
      logger.error("DienteEconomico no encontrada por su asociacion con Odontograma");
      res.json(null);
    }
    logger.info("DienteEconomicos obtenidas correctamente por su asociacion con la Odontograma");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el DienteEconomico mediante por Odontograma: " + error.message);
    res.status(500).json({ error: "Error al obtener DienteEconomicos" });
  }
};

// Obtener una DienteEconomico por ID
exports.getDienteEconomicoById = async (req, res) => {
  try {
    const dato = await DienteEconomico.findByPk(req.params.id);
    if (!dato) {
      logger.error("DienteEconomico no encontrada por su ID");
      return res.status(404).json({ error: "DienteEconomico no encontrada" });
    }
    logger.info("DienteEconomico obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el DienteEconomico mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener DienteEconomico" });
  }
};

// Crear una DienteEconomico
exports.createDienteEconomico = async (req, res) => {
  try {
    const dato = await DienteEconomico.create(req.body);
    logger.info("DienteEconomicos creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un DienteEconomico: " + error.message);
    res.status(500).json({ error: "Error al crear DienteEconomico" });
  }
};

// Actualizar una DienteEconomico
exports.updateDienteEconomico = async (req, res) => {
  try {
    const dato = await DienteEconomico.findByPk(req.params.id);
    if (!dato) {
      logger.error("DienteEconomico no encontrada por su ID");
      return res.status(404).json({ error: "DienteEconomico no encontrada" });
    }
    await dato.update(req.body);
    logger.info("DienteEconomicos actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un DienteEconomico: " + error.message);
    res.status(500).json({ error: "Error al actualizar DienteEconomico" });
  }
};

// Eliminar una DienteEconomico
exports.deleteDienteEconomico = async (req, res) => {
  try {
    const dato = await DienteEconomico.findByPk(req.params.id);
    if (!dato) {
      logger.error("DienteEconomico no encontrada por su ID");
      return res.status(404).json({ error: "DienteEconomico no encontrada" });
    }
    await DienteEconomico.destroy();
    logger.info("DienteEconomicos eliminado correctamente");
    res.json({ message: "DienteEconomico eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un DienteEconomico: " + error.message);
    res.status(500).json({ error: "Error al eliminar DienteEconomico" });
  }
};

