const {Egreso} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Egresoes
exports.getEgresoAll = async (req, res) => {
  try {
    const egresos = await Egreso.findAll();
    logger.info("Egresos obtenidos correctamente");
    res.json(egresos);
  } catch (error) {
    logger.error("Error al obtener Egresos: " + error.message);
    res.status(500).json({ error: "Error al obtener Egresoes" });
  }
};

// Filtrar Egresoes por odontologoId
exports.getEgresoBySede = async (req, res) => {
  try {
    const { sede } = req.params;
    const egresos = await Egreso.findAll(
      {
        where: {
          SedeId: sede
        }
      }
    );

    res.json(egresos);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar Egresoes por odontólogo" });
  }
};

// Obtener una Egreso por ID
exports.getEgresoById = async (req, res) => {
  try {
    const egreso = await Egreso.findByPk(req.params.id);
    if (!egreso) {
      logger.error("Egreso no encontrada por su ID");
      return res.status(404).json({ error: "Egreso no encontrada" });
    }
    logger.info("Egreso obtenido correctamente por su ID");
    res.json(egreso);
  } catch (error) {
    logger.error("Error al obtener el Egreso mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Egreso" });
  }
};

// Crear una Egreso
exports.createEgreso = async (req, res) => {
  try {
    const egreso = await Egreso.create(req.body);
    logger.info("Egresos creado correctamente");
    res.status(201).json(egreso);
  } catch (error) {
    logger.error("Error al crear un Egreso: " + error.message);
    res.status(500).json({ error: "Error al crear Egreso" });
  }
};

// Actualizar una Egreso
exports.updateEgreso = async (req, res) => {
  try {
    const egreso = await Egreso.findByPk(req.params.id);
    if (!egreso) {
      logger.error("Egreso no encontrada por su ID");
      return res.status(404).json({ error: "Egreso no encontrada" });
    }
    await egreso.update(req.body);
    logger.info("Egresos actualizado correctamente");
    res.json(egreso);
  } catch (error) {
    logger.error("Error al actualizar un Egreso: " + error.message);
    res.status(500).json({ error: "Error al actualizar Egreso" });
  }
};

// Eliminar una Egreso
exports.deleteEgreso = async (req, res) => {
  try {
    const egreso = await Egreso.findByPk(req.params.id);
    if (!egreso) {
      logger.error("Egreso no encontrada por su ID");
      return res.status(404).json({ error: "Egreso no encontrada" });
    }
    await egreso.destroy();
    logger.info("Egresos eliminado correctamente");
    res.json({ message: "Egreso eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Egreso: " + error.message);
    res.status(500).json({ error: "Error al eliminar Egreso" });
  }
};
