const {EmitirBoleta} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EmitirBoletaes
exports.getEmitirBoletaAll = async (req, res) => {
  try {
    const emisiones = await EmitirBoleta.findAll();
    logger.info("EmitirBoletas obtenidos correctamente");
    res.json(emisiones);
  } catch (error) {
    logger.error("Error al obtener EmitirBoletas: " + error.message);
    res.status(500).json({ error: "Error al obtener EmitirBoletaes" });
  }
};

// Filtrar EmitirBoletaes por odontologoId
exports.getEmitirBoletaByFactura = async (req, res) => {
  try {
    const { factura } = req.params;
    const emisiones = await EmitirBoleta.findAll(
      {
        where: {
          FacturaId: factura
        }
      }
    );

    res.json(emisiones);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar EmitirBoletaes por odontólogo" });
  }
};

// Obtener una EmitirBoleta por ID
exports.getEmitirBoletaById = async (req, res) => {
  try {
    const emision = await EmitirBoleta.findByPk(req.params.id);
    if (!emision) {
      logger.error("EmitirBoleta no encontrada por su ID");
      return res.status(404).json({ error: "EmitirBoleta no encontrada" });
    }
    logger.info("EmitirBoleta obtenido correctamente por su ID");
    res.json(emision);
  } catch (error) {
    logger.error("Error al obtener el EmitirBoleta mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener EmitirBoleta" });
  }
};

// Crear una EmitirBoleta
exports.createEmitirBoleta = async (req, res) => {
  try {
    const emision = await EmitirBoleta.create(req.body);
    logger.info("EmitirBoletas creado correctamente");
    res.status(201).json(emision);
  } catch (error) {
    logger.error("Error al crear un EmitirBoleta: " + error.message);
    res.status(500).json({ error: "Error al crear EmitirBoleta" });
  }
};

// Actualizar una EmitirBoleta
exports.updateEmitirBoleta = async (req, res) => {
  try {
    const emision = await EmitirBoleta.findByPk(req.params.id);
    if (!emision) {
      logger.error("EmitirBoleta no encontrada por su ID");
      return res.status(404).json({ error: "EmitirBoleta no encontrada" });
    }
    await emision.update(req.body);
    logger.info("EmitirBoletas actualizado correctamente");
    res.json(emision);
  } catch (error) {
    logger.error("Error al actualizar un EmitirBoleta: " + error.message);
    res.status(500).json({ error: "Error al actualizar EmitirBoleta" });
  }
};

// Eliminar una EmitirBoleta
exports.deleteEmitirBoleta = async (req, res) => {
  try {
    const emision = await EmitirBoleta.findByPk(req.params.id);
    if (!emision) {
      logger.error("EmitirBoleta no encontrada por su ID");
      return res.status(404).json({ error: "EmitirBoleta no encontrada" });
    }
    await EmitirBoleta.destroy();
    logger.info("EmitirBoletas eliminado correctamente");
    res.json({ message: "EmitirBoleta eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EmitirBoleta: " + error.message);
    res.status(500).json({ error: "Error al eliminar EmitirBoleta" });
  }
};
