const {EmitirFactura} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EmitirFacturaes
exports.getEmitirFacturaAll = async (req, res) => {
  try {
    const emisiones = await EmitirFactura.findAll();
    logger.info("EmitirFacturas obtenidos correctamente");
    res.json(emisiones);
  } catch (error) {
    logger.error("Error al obtener EmitirFacturas: " + error.message);
    res.status(500).json({ error: "Error al obtener EmitirFacturaes" });
  }
};

// Filtrar EmitirFacturaes por odontologoId
exports.getEmitirFacturaByFactura = async (req, res) => {
  try {
    const { factura } = req.params;
    const emisiones = await EmitirFactura.findAll(
      {
        where: {
          FacturaId: factura
        }
      }
    );

    res.json(emisiones);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar EmitirFacturaes por odontólogo" });
  }
};

// Obtener una EmitirFactura por ID
exports.getEmitirFacturaById = async (req, res) => {
  try {
    const emision = await EmitirFactura.findByPk(req.params.id);
    if (!emision) {
      logger.error("EmitirFactura no encontrada por su ID");
      return res.status(404).json({ error: "EmitirFactura no encontrada" });
    }
    logger.info("EmitirFactura obtenido correctamente por su ID");
    res.json(emision);
  } catch (error) {
    logger.error("Error al obtener el EmitirFactura mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener EmitirFactura" });
  }
};

// Crear una EmitirFactura
exports.createEmitirFactura = async (req, res) => {
  try {
    const emision = await EmitirFactura.create(req.body);
    logger.info("EmitirFacturas creado correctamente");
    res.status(201).json(emision);
  } catch (error) {
    logger.error("Error al crear un EmitirFactura: " + error.message);
    res.status(500).json({ error: "Error al crear EmitirFactura" });
  }
};

// Actualizar una EmitirFactura
exports.updateEmitirFactura = async (req, res) => {
  try {
    const emision = await EmitirFactura.findByPk(req.params.id);
    if (!emision) {
      logger.error("EmitirFactura no encontrada por su ID");
      return res.status(404).json({ error: "EmitirFactura no encontrada" });
    }
    await emision.update(req.body);
    logger.info("EmitirFacturas actualizado correctamente");
    res.json(emision);
  } catch (error) {
    logger.error("Error al actualizar un EmitirFactura: " + error.message);
    res.status(500).json({ error: "Error al actualizar EmitirFactura" });
  }
};

// Eliminar una EmitirFactura
exports.deleteEmitirFactura = async (req, res) => {
  try {
    const emision = await EmitirFactura.findByPk(req.params.id);
    if (!emision) {
      logger.error("EmitirFactura no encontrada por su ID");
      return res.status(404).json({ error: "EmitirFactura no encontrada" });
    }
    await EmitirFactura.destroy();
    logger.info("EmitirFacturas eliminado correctamente");
    res.json({ message: "EmitirFactura eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EmitirFactura: " + error.message);
    res.status(500).json({ error: "Error al eliminar EmitirFactura" });
  }
};
