const {Empresa} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Empresaes
exports.getEmpresaAll = async (req, res) => {
  try {
    const empresas = await Empresa.findAll();
    logger.info("Empresas obtenidos correctamente");
    res.json(empresas);
  } catch (error) {
    logger.error("Error al obtener Empresas: " + error.message);
    res.status(500).json({ error: "Error al obtener Empresaes" });
  }
};

// Obtener una Empresa por ID
exports.getEmpresaById = async (req, res) => {
  try {
    const empresa = await Empresa.findByPk(req.params.id);
    if (!empresa) {
      logger.error("Empresa no encontrada por su ID");
      return res.status(404).json({ error: "Empresa no encontrada" });
    }
    logger.info("Empresa obtenido correctamente por su ID");
    res.json(empresa);
  } catch (error) {
    logger.error("Error al obtener el Empresa mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Empresa" });
  }
};

// Crear una Empresa
exports.createEmpresa = async (req, res) => {
  try {
    const empresa = await Empresa.create(req.body);
    logger.info("Empresas creado correctamente");
    res.status(201).json(empresa);
  } catch (error) {
    logger.error("Error al crear un Empresa: " + error.message);
    res.status(500).json({ error: "Error al crear Empresa" });
  }
};

// Actualizar una Empresa
exports.updateEmpresa = async (req, res) => {
  try {
    const empresa = await Empresa.findByPk(req.params.id);
    if (!empresa) {
      logger.error("Empresa no encontrada por su ID");
      return res.status(404).json({ error: "Empresa no encontrada" });
    }
    await empresa.update(req.body);
    logger.info("Empresas actualizado correctamente");
    res.json(empresa);
  } catch (error) {
    logger.error("Error al actualizar un Empresa: " + error.message);
    res.status(500).json({ error: "Error al actualizar Empresa" });
  }
};

// Eliminar una Empresa
exports.deleteEmpresa = async (req, res) => {
  try {
    const empresa = await Empresa.findByPk(req.params.id);
    if (!empresa) {
      logger.error("Empresa no encontrada por su ID");
      return res.status(404).json({ error: "Empresa no encontrada" });
    }
    await Empresa.destroy();
    logger.info("Empresas eliminado correctamente");
    res.json({ message: "Empresa eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Empresa: " + error.message);
    res.status(500).json({ error: "Error al eliminar Empresa" });
  }
};

