const {EmpresaLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EmpresaLaboratorioes
exports.getEmpresaLaboratorioAll = async (req, res) => {
  try {
    const datos = await EmpresaLaboratorio.findAll();
    logger.info("EmpresaLaboratorios obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener EmpresaLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener EmpresaLaboratorioes" });
  }
};
// Obtener una EmpresaLaboratorio por ID
exports.getEmpresaLaboratorioById = async (req, res) => {
  try {
    const dato = await EmpresaLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("EmpresaLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "EmpresaLaboratorio no encontrada" });
    }
    logger.info("EmpresaLaboratorio obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el EmpresaLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener EmpresaLaboratorio" });
  }
};

// Crear una EmpresaLaboratorio
exports.createEmpresaLaboratorio = async (req, res) => {
  try {
    const dato = await EmpresaLaboratorio.create(req.body);
    logger.info("EmpresaLaboratorios creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un EmpresaLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear EmpresaLaboratorio" });
  }
};

// Actualizar una EmpresaLaboratorio
exports.updateEmpresaLaboratorio = async (req, res) => {
  try {
    const dato = await EmpresaLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("EmpresaLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "EmpresaLaboratorio no encontrada" });
    }
    await dato.update(req.body);
    logger.info("EmpresaLaboratorios actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un EmpresaLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar EmpresaLaboratorio" });
  }
};

// Eliminar una EmpresaLaboratorio
exports.deleteEmpresaLaboratorio = async (req, res) => {
  try {
    const dato = await EmpresaLaboratorio.findByPk(req.params.id);
    if (!dato) {
      logger.error("EmpresaLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "EmpresaLaboratorio no encontrada" });
    }
    await EmpresaLaboratorio.destroy();
    logger.info("EmpresaLaboratorios eliminado correctamente");
    res.json({ message: "EmpresaLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EmpresaLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar EmpresaLaboratorio" });
  }
};

