const {EmpresaRadiografia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EmpresaRadiografiaes
exports.getEmpresaRadiografiaAll = async (req, res) => {
  try {
    const datos = await EmpresaRadiografia.findAll();
    logger.info("EmpresaRadiografias obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener EmpresaRadiografias: " + error.message);
    res.status(500).json({ error: "Error al obtener EmpresaRadiografiaes" });
  }
};
// Obtener una EmpresaRadiografia por ID
exports.getEmpresaRadiografiaById = async (req, res) => {
  try {
    const dato = await EmpresaRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("EmpresaRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "EmpresaRadiografia no encontrada" });
    }
    logger.info("EmpresaRadiografia obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el EmpresaRadiografia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener EmpresaRadiografia" });
  }
};

// Crear una EmpresaRadiografia
exports.createEmpresaRadiografia = async (req, res) => {
  try {
    const dato = await EmpresaRadiografia.create(req.body);
    logger.info("EmpresaRadiografias creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un EmpresaRadiografia: " + error.message);
    res.status(500).json({ error: "Error al crear EmpresaRadiografia" });
  }
};

// Actualizar una EmpresaRadiografia
exports.updateEmpresaRadiografia = async (req, res) => {
  try {
    const dato = await EmpresaRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("EmpresaRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "EmpresaRadiografia no encontrada" });
    }
    await dato.update(req.body);
    logger.info("EmpresaRadiografias actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un EmpresaRadiografia: " + error.message);
    res.status(500).json({ error: "Error al actualizar EmpresaRadiografia" });
  }
};

// Eliminar una EmpresaRadiografia
exports.deleteEmpresaRadiografia = async (req, res) => {
  try {
    const dato = await EmpresaRadiografia.findByPk(req.params.id);
    if (!dato) {
      logger.error("EmpresaRadiografia no encontrada por su ID");
      return res.status(404).json({ error: "EmpresaRadiografia no encontrada" });
    }
    await EmpresaRadiografia.destroy();
    logger.info("EmpresaRadiografias eliminado correctamente");
    res.json({ message: "EmpresaRadiografia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EmpresaRadiografia: " + error.message);
    res.status(500).json({ error: "Error al eliminar EmpresaRadiografia" });
  }
};

