const {EncuestaCompleja} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EncuestaComplejaes
exports.getEncuestaComplejaAll = async (req, res) => {
  try {
    const encuestas = await EncuestaCompleja.findAll();
    logger.info("Encuestas obtenidos correctamente");
    res.json(encuestas);
  } catch (error) {
    logger.error("Error al obtener Encuestas: " + error.message);
    res.status(500).json({ error: "Error al obtener Encuesta" });
  }
};

// Obtener una Encuesta por ID
exports.getEncuestaComplejaById = async (req, res) => {
  try {
    const encuesta = await EncuestaCompleja.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    logger.info("Encuesta obtenido correctamente por su ID");
    res.json(encuesta);
  } catch (error) {
    logger.error("Error al obtener el Encuesta mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Encuesta" });
  }
};

// Crear una Encuesta
exports.createEncuestaCompleja = async (req, res) => {
  try {
    const encuesta = await EncuestaCompleja.create(req.body);
    logger.info("Encuesta creado correctamente");
    res.status(201).json(encuesta);
  } catch (error) {
    logger.error("Error al crear un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al crear Encuesta" });
  }
};

// Actualizar una Encuesta
exports.updateEncuestaCompleja = async (req, res) => {
  try {
    const encuesta = await EncuestaCompleja.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    await encuesta.update(req.body);
    logger.info("Encuesta actualizado correctamente");
    res.json(encuesta);
  } catch (error) {
    logger.error("Error al actualizar un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al actualizar Encuesta" });
  }
};

// Eliminar una Encuesta
exports.deleteEncuestaCompleja = async (req, res) => {
  try {
    const encuesta = await EncuestaCompleja.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    await EncuestaCompleja.destroy();
    logger.info("Encuesta eliminado correctamente");
    res.json({ message: "Encuesta eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EncuestaCompleja: " + error.message);
    res.status(500).json({ error: "Error al eliminar Encuesta" });
  }
};

