const {EncuestaKids} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EncuestaKidses
exports.getEncuestaKidsAll = async (req, res) => {
  try {
    const encuestas = await EncuestaKids.findAll();
    logger.info("Encuestas obtenidos correctamente");
    res.json(encuestas);
  } catch (error) {
    logger.error("Error al obtener Encuestas: " + error.message);
    res.status(500).json({ error: "Error al obtener Encuestas" });
  }
};

// Obtener una Encuesta por ID
exports.getEncuestaKidsById = async (req, res) => {
  try {
    const encuesta = await EncuestaKids.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    logger.info("Encuesta obtenido correctamente por su ID");
    res.json(encuesta);
  } catch (error) {
    logger.error("Error al obtener el Encuesta mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Encuesta" });
  }
};

// Crear una Encuesta
exports.createEncuestaKids = async (req, res) => {
  try {
    const encuesta = await EncuestaKids.create(req.body);
    logger.info("Encuesta creado correctamente");
    res.status(201).json(encuesta);
  } catch (error) {
    logger.error("Error al crear un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al crear Encuesta" });
  }
};

// Actualizar una Encuesta
exports.updateEncuestaKids = async (req, res) => {
  try {
    const encuesta = await EncuestaKids.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    await encuesta.update(req.body);
    logger.info("Encuesta actualizado correctamente");
    res.json(encuesta);
  } catch (error) {
    logger.error("Error al actualizar un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al actualizar Encuesta" });
  }
};

// Eliminar una Encuesta
exports.deleteEncuestaKids = async (req, res) => {
  try {
    const encuesta = await EncuestaKids.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    await EncuestaKids.destroy();
    logger.info("Encuesta eliminado correctamente");
    res.json({ message: "Encuesta eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al eliminar Encuesta" });
  }
};

