const {EncuestaSimple} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EncuestaSimplees
exports.getEncuestaSimpleAll = async (req, res) => {
  try {
    const encuestas = await EncuestaSimple.findAll();
    logger.info("Encuestas obtenidos correctamente");
    res.json(encuestas);
  } catch (error) {
    logger.error("Error al obtener Encuestas: " + error.message);
    res.status(500).json({ error: "Error al obtener Encuestas" });
  }
};

// Obtener una Encuesta por ID
exports.getEncuestaSimpleById = async (req, res) => {
  try {
    const encuesta = await EncuestaSimple.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    logger.info("Encuesta obtenido correctamente por su ID");
    res.json(encuesta);
  } catch (error) {
    logger.error("Error al obtener el Encuesta mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Encuesta" });
  }
};

// Crear una Encuesta
exports.createEncuestaSimple = async (req, res) => {
  try {
    const encuesta = await EncuestaSimple.create(req.body);
    logger.info("Encuesta creado correctamente");
    res.status(201).json(encuesta);
  } catch (error) {
    logger.error("Error al crear un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al crear Encuesta" });
  }
};

// Actualizar una Encuesta
exports.updateEncuestaSimple = async (req, res) => {
  try {
    const encuesta = await EncuestaSimple.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    await encuesta.update(req.body);
    logger.info("Encuesta actualizado correctamente");
    res.json(encuesta);
  } catch (error) {
    logger.error("Error al actualizar un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al actualizar Encuesta" });
  }
};

// Eliminar una Encuesta
exports.deleteEncuestaSimple = async (req, res) => {
  try {
    const encuesta = await EncuestaSimple.findByPk(req.params.id);
    if (!encuesta) {
      logger.error("Encuesta no encontrada por su ID");
      return res.status(404).json({ error: "Encuesta no encontrada" });
    }
    await EncuestaSimple.destroy();
    logger.info("Encuesta eliminado correctamente");
    res.json({ message: "Encuesta eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Encuesta: " + error.message);
    res.status(500).json({ error: "Error al eliminar Encuesta" });
  }
};

