const {EstadoAgendamiento} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoAgendamientoes
exports.getEstadoAgendamientoAll = async (req, res) => {
  try {
    const estadosagendamiento = await EstadoAgendamiento.findAll();
    logger.info("EstadoAgendamientos obtenidos correctamente");
    res.json(estadosagendamiento);
  } catch (error) {
    logger.error("Error al obtener Estado Agendamientos: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado Agendamientoes" });
  }
};

// Obtener una Estado Agendamiento por ID
exports.getEstadoAgendamientoById = async (req, res) => {
  try {
    const estadoagendamiento = await EstadoAgendamiento.findByPk(req.params.id);
    if (!estadoagendamiento) {
      logger.error("Estado Agendamiento no encontrada por su ID");
      return res.status(404).json({ error: "Estado Agendamiento no encontrada" });
    }
    logger.info("Estado Agendamiento obtenido correctamente por su ID");
    res.json(estadoagendamiento);
  } catch (error) {
    logger.error("Error al obtener el Estado Agendamiento mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado Agendamiento" });
  }
};

// Crear una Estado Agendamiento
exports.createEstadoAgendamiento = async (req, res) => {
  try {
    const estadoagendamiento = await EstadoAgendamiento.create(req.body);
    logger.info("Estado Agendamiento creado correctamente");
    res.status(201).json(estadoagendamiento);
  } catch (error) {
    logger.error("Error al crear un Estado Agendamiento: " + error.message);
    res.status(500).json({ error: "Error al crear Estado Agendamiento" });
  }
};

// Actualizar una Estado Agendamiento
exports.updateEstadoAgendamiento = async (req, res) => {
  try {
    const estadoagendamiento = await EstadoAgendamiento.findByPk(req.params.id);
    if (!estadoagendamiento) {
      logger.error("Estado Agendamiento no encontrada por su ID");
      return res.status(404).json({ error: "Estado Agendamiento no encontrada" });
    }
    await estadoagendamiento.update(req.body);
    logger.info("Estado Agendamiento actualizado correctamente");
    res.json(estadoagendamiento);
  } catch (error) {
    logger.error("Error al actualizar un Estado Agendamiento: " + error.message);
    res.status(500).json({ error: "Error al actualizar Estado Agendamiento" });
  }
};

// Eliminar una Estado Agendamiento
exports.deleteEstadoAgendamiento = async (req, res) => {
  try {
    const estadoagendamiento = await EstadoAgendamiento.findByPk(req.params.id);
    if (!estadoagendamiento) {
      logger.error("Estado Agendamiento no encontrada por su ID");
      return res.status(404).json({ error: "Estado Agendamiento no encontrada" });
    }
    await EstadoAgendamiento.destroy();
    logger.info("Estado Agendamientos eliminado correctamente");
    res.json({ message: "Estado Agendamiento eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Estado Agendamiento: " + error.message);
    res.status(500).json({ error: "Error al eliminar Estado Agendamiento" });
  }
};

