const {EstadoCampania} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoCampaniaes
exports.getEstadoCampaniaAll = async (req, res) => {
  try {
    const estadosCampania = await EstadoCampania.findAll();
    logger.info("Estados Campania obtenidos correctamente");
    res.json(estadosCampania);
  } catch (error) {
    logger.error("Error al obtener EstadoCampanias: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoCampaniaes" });
  }
};

// Obtener una Estado Campania por ID
exports.getEstadoCampaniaById = async (req, res) => {
  try {
    const estadoCampania = await EstadoCampania.findByPk(req.params.id);
    if (!estadoCampania) {
      logger.error("Estado Campania no encontrada por su ID");
      return res.status(404).json({ error: "Estado Campania no encontrada" });
    }
    logger.info("Estado Campania obtenido correctamente por su ID");
    res.json(estadoCampania);
  } catch (error) {
    logger.error("Error al obtener el Estado Campania mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado Campania" });
  }
};

// Crear una Estado Campania
exports.createEstadoCampania = async (req, res) => {
  try {
    const estadoCampania = await EstadoCampania.create(req.body);
    logger.info("Estado Campania creado correctamente");
    res.status(201).json(estadoCampania);
  } catch (error) {
    logger.error("Error al crear un Estado Campania: " + error.message);
    res.status(500).json({ error: "Error al crear Estado Campania" });
  }
};

// Actualizar una Estado Campania
exports.updateEstadoCampania = async (req, res) => {
  try {
    const estadoCampania = await EstadoCampania.findByPk(req.params.id);
    if (!estadoCampania) {
      logger.error("Estado Campania no encontrada por su ID");
      return res.status(404).json({ error: "Estado Campania no encontrada" });
    }
    await estadoCampania.update(req.body);
    logger.info("Estado Campania actualizado correctamente");
    res.json(estadoCampania);
  } catch (error) {
    logger.error("Error al actualizar un Estado Campania: " + error.message);
    res.status(500).json({ error: "Error al actualizar Estado Campania" });
  }
};

// Eliminar una Estado Campania
exports.deleteEstadoCampania = async (req, res) => {
  try {
    const estadoCampania = await EstadoCampania.findByPk(req.params.id);
    if (!estadoCampania) {
      logger.error("Estado Campania no encontrada por su ID");
      return res.status(404).json({ error: "Estado Campania no encontrada" });
    }
    await EstadoCampania.destroy();
    logger.info("Estado Campania eliminado correctamente");
    res.json({ message: "Estado Campania eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Estado Campania: " + error.message);
    res.status(500).json({ error: "Error al eliminar Estado Campania" });
  }
};

