const {EstadoDiente} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoDientees
exports.getEstadoDienteAll = async (req, res) => {
  try {
    const datos = await EstadoDiente.findAll();
    logger.info("EstadoDientes obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener EstadoDientes: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoDientees" });
  }
};

// Obtener EstadoDiente por dontograma
exports.getEstadoDienteByOdontograma = async (req, res) => {
  try {
    const { hallazgo, magnitud, posicion } = req.params;
    const datos = await EstadoDiente.findAll(
      {
        where: {
          HallazgoId: hallazgo,
          Magnitud: magnitud,
          Posicion: posicion,
        }
      }
    );
    if (datos.lenghth === 0) {
      logger.error("EstadoDiente no encontrada por su asociacion con Diente");
      res.json(null);
    }
    logger.info("EstadoDientes obtenidas correctamente por su asociacion con la Diente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el EstadoDiente mediante por Diente: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoDientes" });
  }
};

// Obtener una EstadoDiente por ID
exports.getEstadoDienteById = async (req, res) => {
  try {
    const dato = await EstadoDiente.findByPk(req.params.id);
    if (!dato) {
      logger.error("EstadoDiente no encontrada por su ID");
      return res.status(404).json({ error: "EstadoDiente no encontrada" });
    }
    logger.info("EstadoDiente obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el EstadoDiente mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoDiente" });
  }
};

// Crear una EstadoDiente
exports.createEstadoDiente = async (req, res) => {
  try {
    const dato = await EstadoDiente.create(req.body);
    logger.info("EstadoDientes creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un EstadoDiente: " + error.message);
    res.status(500).json({ error: "Error al crear EstadoDiente" });
  }
};

// Actualizar una EstadoDiente
exports.updateEstadoDiente = async (req, res) => {
  try {
    const dato = await EstadoDiente.findByPk(req.params.id);
    if (!dato) {
      logger.error("EstadoDiente no encontrada por su ID");
      return res.status(404).json({ error: "EstadoDiente no encontrada" });
    }
    await dato.update(req.body);
    logger.info("EstadoDientes actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un EstadoDiente: " + error.message);
    res.status(500).json({ error: "Error al actualizar EstadoDiente" });
  }
};

// Eliminar una EstadoDiente
exports.deleteEstadoDiente = async (req, res) => {
  try {
    const dato = await EstadoDiente.findByPk(req.params.id);
    if (!dato) {
      logger.error("EstadoDiente no encontrada por su ID");
      return res.status(404).json({ error: "EstadoDiente no encontrada" });
    }
    await EstadoDiente.destroy();
    logger.info("EstadoDientes eliminado correctamente");
    res.json({ message: "EstadoDiente eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EstadoDiente: " + error.message);
    res.status(500).json({ error: "Error al eliminar EstadoDiente" });
  }
};

