const {EstadoIncidencia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoIncidenciaes
exports.getEstadoIncidenciaAll = async (req, res) => {
  try {
    const estadosincidencia = await EstadoIncidencia.findAll();
    logger.info("Estados Incidencia obtenidos correctamente");
    res.json(estadosincidencia);
  } catch (error) {
    logger.error("Error al obtener Estados Incidencia: " + error.message);
    res.status(500).json({ error: "Error al obtener Estados Incidencia" });
  }
};

// Obtener una Estado Incidencia por ID
exports.getEstadoIncidenciaById = async (req, res) => {
  try {
    const estadoincidencia = await EstadoIncidencia.findByPk(req.params.id);
    if (!estadoincidencia) {
      logger.error("Estado Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Estado Incidencia no encontrada" });
    }
    logger.info("Estado Incidencia obtenido correctamente por su ID");
    res.json(estadoincidencia);
  } catch (error) {
    logger.error("Error al obtener el Estado Incidencia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado Incidencia" });
  }
};

// Crear una Estado Incidencia
exports.createEstadoIncidencia = async (req, res) => {
  try {
    const estadoincidencia = await EstadoIncidencia.create(req.body);
    logger.info("Estado Incidencia creado correctamente");
    res.status(201).json(estadoincidencia);
  } catch (error) {
    logger.error("Error al crear un Estado Incidencia: " + error.message);
    res.status(500).json({ error: "Error al crear Estado Incidencia" });
  }
};

// Actualizar una Estado Incidencia
exports.updateEstadoIncidencia = async (req, res) => {
  try {
    const estadoincidencia = await EstadoIncidencia.findByPk(req.params.id);
    if (!estadoincidencia) {
      logger.error("Estado Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Estado Incidencia no encontrada" });
    }
    await estadoincidencia.update(req.body);
    logger.info("Estado Incidencia actualizado correctamente");
    res.json(estadoincidencia);
  } catch (error) {
    logger.error("Error al actualizar un Estado Incidencia: " + error.message);
    res.status(500).json({ error: "Error al actualizar Estado Incidencia" });
  }
};

// Eliminar una Estado Incidencia
exports.deleteEstadoIncidencia = async (req, res) => {
  try {
    const estadoincidencia = await EstadoIncidencia.findByPk(req.params.id);
    if (!estadoincidencia) {
      logger.error("Estado Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Estado Incidencia no encontrada" });
    }
    await EstadoIncidencia.destroy();
    logger.info("Estado Incidencia eliminado correctamente");
    res.json({ message: "Estado Incidencia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Estado Incidencia: " + error.message);
    res.status(500).json({ error: "Error al eliminar Estado Incidencia" });
  }
};

