const {EstadoOrdenLaboratorio} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoOrdenLaboratorioes
exports.getEstadoOrdenLaboratorioAll = async (req, res) => {
  try {
    const estadosOrdenLaboratorio = await EstadoOrdenLaboratorio.findAll();
    logger.info("Estados OrdenLaboratorio obtenidos correctamente");
    res.json(estadosOrdenLaboratorio);
  } catch (error) {
    logger.error("Error al obtener EstadoOrdenLaboratorios: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoOrdenLaboratorioes" });
  }
};

// Obtener una Estado OrdenLaboratorio por ID
exports.getEstadoOrdenLaboratorioById = async (req, res) => {
  try {
    const estadoOrdenLaboratorio = await EstadoOrdenLaboratorio.findByPk(req.params.id);
    if (!estadoOrdenLaboratorio) {
      logger.error("Estado OrdenLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "Estado OrdenLaboratorio no encontrada" });
    }
    logger.info("Estado OrdenLaboratorio obtenido correctamente por su ID");
    res.json(estadoOrdenLaboratorio);
  } catch (error) {
    logger.error("Error al obtener el Estado OrdenLaboratorio mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado OrdenLaboratorio" });
  }
};

// Crear una Estado OrdenLaboratorio
exports.createEstadoOrdenLaboratorio = async (req, res) => {
  try {
    const estadoOrdenLaboratorio = await EstadoOrdenLaboratorio.create(req.body);
    logger.info("Estado OrdenLaboratorio creado correctamente");
    res.status(201).json(estadoOrdenLaboratorio);
  } catch (error) {
    logger.error("Error al crear un Estado OrdenLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al crear Estado OrdenLaboratorio" });
  }
};

// Actualizar una Estado OrdenLaboratorio
exports.updateEstadoOrdenLaboratorio = async (req, res) => {
  try {
    const estadoOrdenLaboratorio = await EstadoOrdenLaboratorio.findByPk(req.params.id);
    if (!estadoOrdenLaboratorio) {
      logger.error("Estado OrdenLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "Estado OrdenLaboratorio no encontrada" });
    }
    await estadoOrdenLaboratorio.update(req.body);
    logger.info("Estado OrdenLaboratorio actualizado correctamente");
    res.json(estadoOrdenLaboratorio);
  } catch (error) {
    logger.error("Error al actualizar un Estado OrdenLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al actualizar Estado OrdenLaboratorio" });
  }
};

// Eliminar una Estado OrdenLaboratorio
exports.deleteEstadoOrdenLaboratorio = async (req, res) => {
  try {
    const estadoOrdenLaboratorio = await EstadoOrdenLaboratorio.findByPk(req.params.id);
    if (!estadoOrdenLaboratorio) {
      logger.error("Estado OrdenLaboratorio no encontrada por su ID");
      return res.status(404).json({ error: "Estado OrdenLaboratorio no encontrada" });
    }
    await EstadoOrdenLaboratorio.destroy();
    logger.info("Estado OrdenLaboratorio eliminado correctamente");
    res.json({ message: "Estado OrdenLaboratorio eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Estado OrdenLaboratorio: " + error.message);
    res.status(500).json({ error: "Error al eliminar Estado OrdenLaboratorio" });
  }
};

