const {EstadoPago} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoPagoes
exports.getEstadoPagoAll = async (req, res) => {
  try {
    const estadospago = await EstadoPago.findAll();
    logger.info("Estados Pago obtenidos correctamente");
    res.json(estadospago);
  } catch (error) {
    logger.error("Error al obtener EstadoPagos: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoPagoes" });
  }
};

// Obtener una Estado Pago por ID
exports.getEstadoPagoById = async (req, res) => {
  try {
    const estadopago = await EstadoPago.findByPk(req.params.id);
    if (!estadopago) {
      logger.error("Estado Pago no encontrada por su ID");
      return res.status(404).json({ error: "Estado Pago no encontrada" });
    }
    logger.info("Estado Pago obtenido correctamente por su ID");
    res.json(estadopago);
  } catch (error) {
    logger.error("Error al obtener el Estado Pago mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado Pago" });
  }
};

// Crear una Estado Pago
exports.createEstadoPago = async (req, res) => {
  try {
    const estadopago = await EstadoPago.create(req.body);
    logger.info("Estado Pago creado correctamente");
    res.status(201).json(estadopago);
  } catch (error) {
    logger.error("Error al crear un Estado Pago: " + error.message);
    res.status(500).json({ error: "Error al crear Estado Pago" });
  }
};

// Actualizar una Estado Pago
exports.updateEstadoPago = async (req, res) => {
  try {
    const estadopago = await EstadoPago.findByPk(req.params.id);
    if (!estadopago) {
      logger.error("Estado Pago no encontrada por su ID");
      return res.status(404).json({ error: "Estado Pago no encontrada" });
    }
    await estadopago.update(req.body);
    logger.info("Estado Pago actualizado correctamente");
    res.json(estadopago);
  } catch (error) {
    logger.error("Error al actualizar un Estado Pago: " + error.message);
    res.status(500).json({ error: "Error al actualizar Estado Pago" });
  }
};

// Eliminar una Estado Pago
exports.deleteEstadoPago = async (req, res) => {
  try {
    const estadopago = await EstadoPago.findByPk(req.params.id);
    if (!estadopago) {
      logger.error("Estado Pago no encontrada por su ID");
      return res.status(404).json({ error: "Estado Pago no encontrada" });
    }
    await EstadoPago.destroy();
    logger.info("Estado Pago eliminado correctamente");
    res.json({ message: "Estado Pago eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Estado Pago: " + error.message);
    res.status(500).json({ error: "Error al eliminar Estado Pago" });
  }
};

