const {EstadoUsuario} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las EstadoUsuarioes
exports.getEstadoUsuarioAll = async (req, res) => {
  try {
    const estados = await EstadoUsuario.findAll();
    logger.info("EstadoUsuarios obtenidos correctamente");
    res.json(estados);
  } catch (error) {
    logger.error("Error al obtener EstadoUsuarios: " + error.message);
    res.status(500).json({ error: "Error al obtener EstadoUsuarioes" });
  }
};

// Obtener una Estado Usuario por ID
exports.getEstadoUsuarioById = async (req, res) => {
  try {
    const estado = await EstadoUsuario.findByPk(req.params.id);
    if (!estado) {
      logger.error("Estado Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Estado Usuario no encontrada" });
    }
    logger.info("EstadoUsuario obtenido correctamente por su ID");
    res.json(estado);
  } catch (error) {
    logger.error("Error al obtener el EstadoUsuario mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Estado Usuario" });
  }
};

// Crear una Estado Usuario
exports.createEstadoUsuario = async (req, res) => {
  try {
    const estado = await EstadoUsuario.create(req.body);
    logger.info("EstadoUsuarios creado correctamente");
    res.status(201).json(estado);
  } catch (error) {
    logger.error("Error al crear un EstadoUsuario: " + error.message);
    res.status(500).json({ error: "Error al crear Estado Usuario" });
  }
};

// Actualizar una Estado Usuario
exports.updateEstadoUsuario = async (req, res) => {
  try {
    const estado = await EstadoUsuario.findByPk(req.params.id);
    if (!estado) {
      logger.error("Estado Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Estado Usuario no encontrada" });
    }
    await estado.update(req.body);
    logger.info("EstadoUsuarios actualizado correctamente");
    res.json(EstadoUsuario);
  } catch (error) {
    logger.error("Error al actualizar un EstadoUsuario: " + error.message);
    res.status(500).json({ error: "Error al actualizar Estado Usuario" });
  }
};

// Eliminar una Estado Usuario
exports.deleteEstadoUsuario = async (req, res) => {
  try {
    const estado = await EstadoUsuario.findByPk(req.params.id);
    if (!estado) {
      logger.error("Estado Usuario no encontrada por su ID");
      return res.status(404).json({ error: "Estado Usuario no encontrada" });
    }
    await EstadoUsuario.destroy();
    logger.info("EstadoUsuarios eliminado correctamente");
    res.json({ message: "Estado Usuario eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un EstadoUsuario: " + error.message);
    res.status(500).json({ error: "Error al eliminar Estado Usuario" });
  }
};

