const {Evaluacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Evaluaciones
exports.getEvaluacionAll = async (req, res) => {
  try {
    const evaluaciones = await Evaluacion.findAll();
    logger.info("Evaluacions obtenidos correctamente");
    res.json(evaluaciones);
  } catch (error) {
    logger.error("Error al obtener Evaluacions: " + error.message);
    res.status(500).json({ error: "Error al obtener Evaluaciones" });
  }
};

// Obtener todas las Evaluaciones por trabajador
exports.getEvaluacionByTrabajador = async (req, res) => {
  try {
    const { trabajador } = req.params;
    const evaluaciones = await Evaluacion.findAll(
      {
        where: {
          UsuarioId: trabajador
        },
        order: [['FechaEvaluacion', 'DESC']] // Ordenar por fecharegistro en orden descendente
      }
    );
    logger.info("Evaluacions obtenidos correctamente");
    res.json(evaluaciones);
  } catch (error) {
    logger.error("Error al obtener Evaluacions: " + error.message);
    res.status(500).json({ error: "Error al obtener Evaluaciones" });
  }
};

// Obtener una Evaluacion por ID
exports.getEvaluacionById = async (req, res) => {
  try {
    const evaluacion = await Evaluacion.findByPk(req.params.id);
    if (!evaluacion) {
      logger.error("Evaluacion no encontrada por su ID");
      return res.status(404).json({ error: "Evaluacion no encontrada" });
    }
    logger.info("Evaluacion obtenido correctamente por su ID");
    res.json(evaluacion);
  } catch (error) {
    logger.error("Error al obtener el Evaluacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Evaluacion" });
  }
};

// Crear una Evaluacion
exports.createEvaluacion = async (req, res) => {
  try {
    const evaluacion = await Evaluacion.create(req.body);
    logger.info("Evaluacions creado correctamente");
    res.status(201).json(evaluacion);
  } catch (error) {
    logger.error("Error al crear un Evaluacion: " + error.message);
    res.status(500).json({ error: "Error al crear Evaluacion" });
  }
};

// Actualizar una Evaluacion
exports.updateEvaluacion = async (req, res) => {
  try {
    const evaluacion = await Evaluacion.findByPk(req.params.id);
    if (!evaluacion) {
      logger.error("Evaluacion no encontrada por su ID");
      return res.status(404).json({ error: "Evaluacion no encontrada" });
    }
    await evaluacion.update(req.body);
    logger.info("Evaluacions actualizado correctamente");
    res.json(evaluacion);
  } catch (error) {
    logger.error("Error al actualizar un Evaluacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Evaluacion" });
  }
};

// Eliminar una Evaluacion
exports.deleteEvaluacion = async (req, res) => {
  try {
    const Evaluacion = await Evaluacion.findByPk(req.params.id);
    if (!Evaluacion) {
      logger.error("Evaluacion no encontrada por su ID");
      return res.status(404).json({ error: "Evaluacion no encontrada" });
    }
    await Evaluacion.destroy();
    logger.info("Evaluacions eliminado correctamente");
    res.json({ message: "Evaluacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Evaluacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Evaluacion" });
  }
};

