const fs = require('fs').promises;
const path = require('path');
const {
  Usuario,
  Paciente,
  Ubicacion,
  Agendamiento,
  Familiar,
  Covertura,
  Atiende,
  Tarifario, Ingreso, Egreso, ItemTarifario, PresupuestoParcial, PresupuestoTotal,
  Factura, ItemFactura, Facturacion, EmisionFactura, EmisionBoleta
} = require('../models'); // Ajusta la ruta según tu estructura

// Método para exportar datos a un archivo JSON
exports.exportDataPaciente = async (req, res) => {
  try {
    // Obtiene los datos de cada modelo
    const pacientes = await Paciente.findAll();
    const familiares = await Familiar.findAll();
    const coverturas = await Covertura.findAll();
    // Estructura la data en un objeto
    const data = {
      pacientes: pacientes,
      familiares: familiares,
      coverturas: coverturas
    };
    // Convierte el objeto a una cadena JSON con indentación de 2 espacios
    const jsonData = JSON.stringify(data, null, 2);
    // Ruta donde se guardará el archivo data.json (en la carpeta "data")
    const filePath = path.join(__dirname, '../data', 'datapaciente.json');
    // Escribe el archivo de forma asíncrona
    await fs.writeFile(filePath, jsonData, 'utf8');
    res.json(
      {
        message: 'Archivo JSON guardado exitosamente en la carpeta "data".'
      }
    );
  } catch (error) {
    console.error('Error exportando los datos:', error);
    res.status(500).json(
      {
        error: 'Error exportando los datos.'
      }
    );
  }
};

// Método para exportar datos a un archivo JSON
exports.exportDataUsuario = async (req, res) => {
  try {
    // Obtiene los datos de cada modelo
    const usuarios = await Usuario.findAll();
    const ubicaciones = await Ubicacion.findAll();
    const atiendes = await Atiende.findAll();
    // Estructura la data en un objeto
    const data = {
      usuarios: usuarios,
      ubicaciones: ubicaciones,
      atiendes: atiendes
    };
    // Convierte el objeto a una cadena JSON con indentación de 2 espacios
    const jsonData = JSON.stringify(data, null, 2);
    // Ruta donde se guardará el archivo data.json (en la carpeta "data")
    const filePath = path.join(__dirname, '../data', 'datausuario.json');
    // Escribe el archivo de forma asíncrona
    await fs.writeFile(filePath, jsonData, 'utf8');
    res.json(
      {
        message: 'Archivo JSON guardado exitosamente en la carpeta "data".'
      }
    );
  } catch (error) {
    console.error('Error exportando los datos:', error);
    res.status(500).json(
      {
        error: 'Error exportando los datos.'
      }
    );
  }
};

// Método para exportar datos a un archivo JSON
exports.exportDataAgendamiento = async (req, res) => {
  try {
    // Obtiene los datos de cada modelo
    const citas = await Agendamiento.findAll();
    // Estructura la data en un objeto
    const data = {
      citas: citas
    };
    // Convierte el objeto a una cadena JSON con indentación de 2 espacios
    const jsonData = JSON.stringify(data, null, 2);
    // Ruta donde se guardará el archivo data.json (en la carpeta "data")
    const filePath = path.join(__dirname, '../data', 'dataagedamiento.json');
    // Escribe el archivo de forma asíncrona
    await fs.writeFile(filePath, jsonData, 'utf8');
    res.json(
      {
        message: 'Archivo JSON guardado exitosamente en la carpeta "data".'
      }
    );
  } catch (error) {
    console.error('Error exportando los datos:', error);
    res.status(500).json(
      {
        error: 'Error exportando los datos.'
      }
    );
  }
};

// Método para exportar datos a un archivo JSON
exports.exportDataAuditoria = async (req, res) => {
  try {
    // Obtiene los datos de cada modelo
    const auditorias = await Auditoria.findAll();
    // Estructura la data en un objeto
    const data = {
      auditorias: auditorias
    };
    // Convierte el objeto a una cadena JSON con indentación de 2 espacios
    const jsonData = JSON.stringify(data, null, 2);
    // Ruta donde se guardará el archivo data.json (en la carpeta "data")
    const filePath = path.join(__dirname, '../data', 'dataauditoria.json');
    // Escribe el archivo de forma asíncrona
    await fs.writeFile(filePath, jsonData, 'utf8');
    res.json(
      {
        message: 'Archivo JSON guardado exitosamente en la carpeta "data".'
      }
    );
  } catch (error) {
    console.error('Error exportando los datos:', error);
    res.status(500).json(
      {
        error: 'Error exportando los datos.'
      }
    );
  }
};

// Método para exportar datos a un archivo JSON
exports.exportDataEconomia1 = async (req, res) => {
  try {
    // Obtiene los datos de cada modelo
    const tarifarios = await Tarifario.findAll();
    const ingresos = await Ingreso.findAll();
    const egresos = await Egreso.findAll();
    const itemstarifario = await ItemTarifario.findAll();
    const facturas = await Factura.findAll();
    const itemsfactura = await ItemFactura.findAll();
    // Estructura la data en un objeto
    const data = {
      tarifarios: tarifarios,
      ingresos: ingresos,
      egresos: egresos,
      itemstarifario: itemstarifario,
      facturas: facturas,
      itemsfactura: itemsfactura
    };
    // Convierte el objeto a una cadena JSON con indentación de 2 espacios
    const jsonData = JSON.stringify(data, null, 2);
    // Ruta donde se guardará el archivo data.json (en la carpeta "data")
    const filePath = path.join(__dirname, '../data', 'dataeconomia.json');
    // Escribe el archivo de forma asíncrona
    await fs.writeFile(filePath, jsonData, 'utf8');
    res.json(
      {
        message: 'Archivo JSON guardado exitosamente en la carpeta "data".'
      }
    );
  } catch (error) {
    console.error('Error exportando los datos:', error);
    res.status(500).json(
      {
        error: 'Error exportando los datos.'
      }
    );
  }
};

// Método para exportar datos a un archivo JSON
exports.exportDataEconomia2 = async (req, res) => {
  try {
    // Obtiene los datos de cada modelo
    const facturaciones = await Facturacion.findAll();
    const presupuestosparciales = await PresupuestoParcial.findAll();
    const presupuestostotales = await PresupuestoTotal.findAll();
    const emisionesdefactura = await EmisionFactura.findAll();
    const emisionesdeboleta = await EmisionBoleta.findAll();
    // Estructura la data en un objeto
    const data = {
      facturaciones: facturaciones,
      presupuestosparciales: presupuestosparciales,
      presupuestostotales: presupuestostotales,
      emisionesdefactura: emisionesdefactura,
      emisionesdeboleta: emisionesdeboleta
    };
    // Convierte el objeto a una cadena JSON con indentación de 2 espacios
    const jsonData = JSON.stringify(data, null, 2);
    // Ruta donde se guardará el archivo data.json (en la carpeta "data")
    const filePath = path.join(__dirname, '../data', 'datapresupuesto.json');
    // Escribe el archivo de forma asíncrona
    await fs.writeFile(filePath, jsonData, 'utf8');
    res.json(
      {
        message: 'Archivo JSON guardado exitosamente en la carpeta "data".'
      }
    );
  } catch (error) {
    console.error('Error exportando los datos:', error);
    res.status(500).json(
      {
        error: 'Error exportando los datos.'
      }
    );
  }
};