const {Factura} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Facturaes
exports.getFacturaAll = async (req, res) => {
  try {
    const facturas = await Factura.findAll();
    logger.info("Facturas obtenidos correctamente");
    res.json(facturas);
  } catch (error) {
    logger.error("Error al obtener Facturas: " + error.message);
    res.status(500).json({ error: "Error al obtener Facturaes" });
  }
};

// Filtrar Facturaes por odontologoId
exports.filtrarPorSede = async (req, res) => {
  try {
    const { sede } = req.params;
    const facturas = await Factura.findAll(
      {
        where: {
          SedeId: sede
        }
      }
    );

    res.json(facturas);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar Facturaes por odontólogo" });
  }
};


// Filtrar Facturaes por odontologoId
exports.filtrarPorPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const facturas = await Factura.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );

    res.json(facturas);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar Facturaes por odontólogo" });
  }
};

// Obtener una Factura por ID
exports.getFacturaById = async (req, res) => {
  try {
    const factura = await Factura.findByPk(req.params.id);
    if (!factura) {
      logger.error("Factura no encontrada por su ID");
      return res.status(404).json({ error: "Factura no encontrada" });
    }
    logger.info("Factura obtenido correctamente por su ID");
    res.json(factura);
  } catch (error) {
    logger.error("Error al obtener el Factura mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Factura" });
  }
};

// Crear una Factura
exports.createFactura = async (req, res) => {
  try {
    const factura = await Factura.create(req.body);
    logger.info("Facturas creado correctamente");
    res.status(201).json(factura);
  } catch (error) {
    logger.error("Error al crear un Factura: " + error.message);
    res.status(500).json({ error: "Error al crear Factura" });
  }
};

// Actualizar una Factura
exports.updateFactura = async (req, res) => {
  try {
    const factura = await Factura.findByPk(req.params.id);
    if (!factura) {
      logger.error("Factura no encontrada por su ID");
      return res.status(404).json({ error: "Factura no encontrada" });
    }
    await factura.update(req.body);
    logger.info("Facturas actualizado correctamente");
    res.json(factura);
  } catch (error) {
    logger.error("Error al actualizar un Factura: " + error.message);
    res.status(500).json({ error: "Error al actualizar Factura" });
  }
};

// Eliminar una Factura
exports.deleteFactura = async (req, res) => {
  try {
    const factura = await Factura.findByPk(req.params.id);
    if (!factura) {
      logger.error("Factura no encontrada por su ID");
      return res.status(404).json({ error: "Factura no encontrada" });
    }
    await Factura.destroy();
    logger.info("Facturas eliminado correctamente");
    res.json({ message: "Factura eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Factura: " + error.message);
    res.status(500).json({ error: "Error al eliminar Factura" });
  }
};
