const {Facturacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Facturaciones
exports.getFacturacionAll = async (req, res) => {
  try {
    const facturaciones = await Facturacion.findAll();
    logger.info("Facturacions obtenidos correctamente");
    res.json(facturaciones);
  } catch (error) {
    logger.error("Error al obtener Facturacions: " + error.message);
    res.status(500).json({ error: "Error al obtener Facturaciones" });
  }
};

// Filtrar Facturaciones por odontologoId
exports.getFacturacionByFactura = async (req, res) => {
  try {
    const { factura } = req.params;
    const facturaciones = await Facturacion.findAll(
      {
        where: {
          FacturaId: factura
        }
      }
    );

    res.json(facturaciones);
  } catch (error) {
    res.status(500).json({ error: "Error al filtrar Facturaciones por odontólogo" });
  }
};

// Obtener una Facturacion por ID
exports.getFacturacionById = async (req, res) => {
  try {
    const facturacion = await Facturacion.findByPk(req.params.id);
    if (!facturacion) {
      logger.error("Facturacion no encontrada por su ID");
      return res.status(404).json({ error: "Facturacion no encontrada" });
    }
    logger.info("Facturacion obtenido correctamente por su ID");
    res.json(facturacion);
  } catch (error) {
    logger.error("Error al obtener el Facturacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Facturacion" });
  }
};

// Crear una Facturacion
exports.createFacturacion = async (req, res) => {
  try {
    const facturacion = await Facturacion.create(req.body);
    logger.info("Facturacions creado correctamente");
    res.status(201).json(facturacion);
  } catch (error) {
    logger.error("Error al crear un Facturacion: " + error.message);
    res.status(500).json({ error: "Error al crear Facturacion" });
  }
};

// Actualizar una Facturacion
exports.updateFacturacion = async (req, res) => {
  try {
    const facturacion = await Facturacion.findByPk(req.params.id);
    if (!facturacion) {
      logger.error("Facturacion no encontrada por su ID");
      return res.status(404).json({ error: "Facturacion no encontrada" });
    }
    await facturacion.update(req.body);
    logger.info("Facturacions actualizado correctamente");
    res.json(facturacion);
  } catch (error) {
    logger.error("Error al actualizar un Facturacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Facturacion" });
  }
};

// Eliminar una Facturacion
exports.deleteFacturacion = async (req, res) => {
  try {
    const facturacion = await Facturacion.findByPk(req.params.id);
    if (!facturacion) {
      logger.error("Facturacion no encontrada por su ID");
      return res.status(404).json({ error: "Facturacion no encontrada" });
    }
    await Facturacion.destroy();
    logger.info("Facturacions eliminado correctamente");
    res.json({ message: "Facturacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Facturacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Facturacion" });
  }
};
