const {Familiar} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Familiares
exports.getFamiliarAll = async (req, res) => {
  try {
    const familiares = await Familiar.findAll();
    logger.info("Familiars obtenidos correctamente");
    res.json(familiares);
  } catch (error) {
    logger.error("Error al obtener Familiars: " + error.message);
    res.status(500).json({ error: "Error al obtener Familiares" });
  }
};
// Obtener una Familiar por Empresa
exports.getFamiliarByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const familiares = await Familiar.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!familiares) {
      logger.error("Familiar no encontrada por su asociacion con paciente");
      return res.status(404).json({ error: "Familiars no encontrada" });
    }
    logger.info("Familiars obtenidas correctamente por su asociacion con el paciente");
    res.json(familiares);
  } catch (error) {
    logger.error("Error al obtener el Familiar mediante por paciente: " + error.message);
    res.status(500).json({ error: "Error al obtener Familiars" });
  }
};

// Obtener una Familiar por ID
exports.getFamiliarById = async (req, res) => {
  try {
    const familiar = await Familiar.findByPk(req.params.id);
    if (!familiar) {
      logger.error("Familiar no encontrada por su ID");
      return res.status(404).json({ error: "Familiar no encontrada" });
    }
    logger.info("Familiar obtenido correctamente por su ID");
    res.json(familiar);
  } catch (error) {
    logger.error("Error al obtener el Familiar mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Familiar" });
  }
};

// Crear una Familiar
exports.createFamiliar = async (req, res) => {
  try {
    const familiar = await Familiar.create(req.body);
    logger.info("Familiars creado correctamente");
    res.status(201).json(familiar);
  } catch (error) {
    logger.error("Error al crear un Familiar: " + error.message);
    res.status(500).json({ error: "Error al crear Familiar" });
  }
};

// Actualizar una Familiar
exports.updateFamiliar = async (req, res) => {
  try {
    const familiar = await Familiar.findByPk(req.params.id);
    if (!familiar) {
      logger.error("familiar no encontrada por su ID");
      return res.status(404).json({ error: "Familiar no encontrada" });
    }
    await familiar.update(req.body);
    logger.info("familiar actualizado correctamente");
    res.json(familiar);
  } catch (error) {
    logger.error("Error al actualizar un Familiar: " + error.message);
    res.status(500).json({ error: "Error al actualizar Familiar" });
  }
};

// Eliminar una Familiar
exports.deleteFamiliar = async (req, res) => {
  try {
    const familiar = await Familiar.findByPk(req.params.id);
    if (!familiar) {
      logger.error("Familiar no encontrada por su ID");
      return res.status(404).json({ error: "Familiar no encontrada" });
    }
    await Familiar.destroy();
    logger.info("familiar eliminado correctamente");
    res.json({ message: "Familiar eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Familiar: " + error.message);
    res.status(500).json({ error: "Error al eliminar Familiar" });
  }
};

