const {Fotos} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Fotoses
exports.getFotosAll = async (req, res) => {
  try {
    const datos = await Fotos.findAll();
    logger.info("Fotoss obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener Fotoss: " + error.message);
    res.status(500).json({ error: "Error al obtener Fotoses" });
  }
};

// Obtener Fotos por Historia Clinica
exports.getFotosByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const datos = await Fotos.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!datos) {
      logger.error("Fotos no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Fotoss no encontrada" });
    }
    logger.info("Fotoss obtenidas correctamente por su asociacion con la Empresa");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener el Fotos mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Fotoss" });
  }
};

// Obtener una Fotos por ID
exports.getFotosById = async (req, res) => {
  try {
    const dato = await Fotos.findByPk(req.params.id);
    if (!dato) {
      logger.error("Fotos no encontrada por su ID");
      return res.status(404).json({ error: "Fotos no encontrada" });
    }
    logger.info("Fotos obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el Fotos mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Fotos" });
  }
};

// Crear una Fotos
exports.createFotos = async (req, res) => {
  try {
    const dato = await Fotos.create(req.body);
    logger.info("Fotoss creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un Fotos: " + error.message);
    res.status(500).json({ error: "Error al crear Fotos" });
  }
};

// Actualizar una Fotos
exports.updateFotos = async (req, res) => {
  try {
    const dato = await Fotos.findByPk(req.params.id);
    if (!dato) {
      logger.error("Fotos no encontrada por su ID");
      return res.status(404).json({ error: "Fotos no encontrada" });
    }
    await dato.update(req.body);
    logger.info("Fotoss actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un Fotos: " + error.message);
    res.status(500).json({ error: "Error al actualizar Fotos" });
  }
};

// Eliminar una Fotos
exports.deleteFotos = async (req, res) => {
  try {
    const dato = await Fotos.findByPk(req.params.id);
    if (!dato) {
      logger.error("Fotos no encontrada por su ID");
      return res.status(404).json({ error: "Fotos no encontrada" });
    }
    await Fotos.destroy();
    logger.info("Fotoss eliminado correctamente");
    res.json({ message: "Fotos eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Fotos: " + error.message);
    res.status(500).json({ error: "Error al eliminar Fotos" });
  }
};

