const {FuenteCaptacion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las FuenteCaptaciones
exports.getFuenteCaptacionAll = async (req, res) => {
  try {
    const fuentescaptacion = await FuenteCaptacion.findAll();
    logger.info("Fuentes Captacion obtenidos correctamente");
    res.json(fuentescaptacion);
  } catch (error) {
    logger.error("Error al obtener Fuentes Captacion: " + error.message);
    res.status(500).json({ error: "Error al obtener FuenteCaptaciones" });
  }
};

// Obtener una Fuente Captacion por ID
exports.getFuenteCaptacionById = async (req, res) => {
  try {
    const fuentecaptacion = await FuenteCaptacion.findByPk(req.params.id);
    if (!fuentecaptacion) {
      logger.error("Fuente Captacion no encontrada por su ID");
      return res.status(404).json({ error: "Fuente Captacion no encontrada" });
    }
    logger.info("Fuente Captacion obtenido correctamente por su ID");
    res.json(fuentecaptacion);
  } catch (error) {
    logger.error("Error al obtener el Fuente Captacion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Fuente Captacion" });
  }
};

// Crear una Fuente Captacion
exports.createFuenteCaptacion = async (req, res) => {
  try {
    const fuentecaptacion = await FuenteCaptacion.create(req.body);
    logger.info("Fuente Captacion creado correctamente");
    res.status(201).json(fuentecaptacion);
  } catch (error) {
    logger.error("Error al crear un FuenteCaptacion: " + error.message);
    res.status(500).json({ error: "Error al crear Fuente Captacion" });
  }
};

// Actualizar una Fuente Captacion
exports.updateFuenteCaptacion = async (req, res) => {
  try {
    const fuentecaptacion = await FuenteCaptacion.findByPk(req.params.id);
    if (!fuentecaptacion) {
      logger.error("Fuente Captacion no encontrada por su ID");
      return res.status(404).json({ error: "Fuente Captacion no encontrada" });
    }
    await fuentecaptacion.update(req.body);
    logger.info("Fuente Captacion actualizado correctamente");
    res.json(fuentecaptacion);
  } catch (error) {
    logger.error("Error al actualizar un Fuente Captacion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Fuente Captacion" });
  }
};

// Eliminar una Fuente Captacion
exports.deleteFuenteCaptacion = async (req, res) => {
  try {
    const fuentecaptacion = await FuenteCaptacion.findByPk(req.params.id);
    if (!fuentecaptacion) {
      logger.error("Fuente Captacion no encontrada por su ID");
      return res.status(404).json({ error: "Fuente Captacion no encontrada" });
    }
    await FuenteCaptacion.destroy();
    logger.info("Fuente Captacion eliminado correctamente");
    res.json({ message: "Fuente Captacion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Fuente Captacion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Fuente Captacion" });
  }
};

