const {Genero} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Generoes
exports.getGeneroAll = async (req, res) => {
  try {
    const generos = await Genero.findAll();
    logger.info("Generos obtenidos correctamente");
    res.json(generos);
  } catch (error) {
    logger.error("Error al obtener Generos: " + error.message);
    res.status(500).json({ error: "Error al obtener Generoes" });
  }
};

// Obtener una Genero por ID
exports.getGeneroById = async (req, res) => {
  try {
    const genero = await Genero.findByPk(req.params.id);
    if (!genero) {
      logger.error("Genero no encontrada por su ID");
      return res.status(404).json({ error: "Genero no encontrada" });
    }
    logger.info("Genero obtenido correctamente por su ID");
    res.json(genero);
  } catch (error) {
    logger.error("Error al obtener el Genero mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Genero" });
  }
};

// Crear una Genero
exports.createGenero = async (req, res) => {
  try {
    const genero = await Genero.create(req.body);
    logger.info("Generos creado correctamente");
    res.status(201).json(genero);
  } catch (error) {
    logger.error("Error al crear un Genero: " + error.message);
    res.status(500).json({ error: "Error al crear Genero" });
  }
};

// Actualizar una Genero
exports.updateGenero = async (req, res) => {
  try {
    const genero = await Genero.findByPk(req.params.id);
    if (!genero) {
      logger.error("Genero no encontrada por su ID");
      return res.status(404).json({ error: "Genero no encontrada" });
    }
    await genero.update(req.body);
    logger.info("Generos actualizado correctamente");
    res.json(genero);
  } catch (error) {
    logger.error("Error al actualizar un Genero: " + error.message);
    res.status(500).json({ error: "Error al actualizar Genero" });
  }
};

// Eliminar una Genero
exports.deleteGenero = async (req, res) => {
  try {
    const genero = await Genero.findByPk(req.params.id);
    if (!genero) {
      logger.error("Genero no encontrada por su ID");
      return res.status(404).json({ error: "Genero no encontrada" });
    }
    await Genero.destroy();
    logger.info("Generos eliminado correctamente");
    res.json({ message: "Genero eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Genero: " + error.message);
    res.status(500).json({ error: "Error al eliminar Genero" });
  }
};

