const {GradoInstruccion} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las GradoInstrucciones
exports.getGradoInstruccionAll = async (req, res) => {
  try {
    const gradosinstruccion = await GradoInstruccion.findAll();
    logger.info("GradoInstruccions obtenidos correctamente");
    res.json(gradosinstruccion);
  } catch (error) {
    logger.error("Error al obtener GradoInstruccions: " + error.message);
    res.status(500).json({ error: "Error al obtener GradoInstrucciones" });
  }
};

// Obtener una Grado Instruccion por ID
exports.getGradoInstruccionById = async (req, res) => {
  try {
    const gradoinstruccion = await GradoInstruccion.findByPk(req.params.id);
    if (!gradoinstruccion) {
      logger.error("Grado Instruccion no encontrada por su ID");
      return res.status(404).json({ error: "Grado Instruccion no encontrada" });
    }
    logger.info("GradoInstruccion obtenido correctamente por su ID");
    res.json(gradoinstruccion);
  } catch (error) {
    logger.error("Error al obtener el GradoInstruccion mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Grado Instruccion" });
  }
};

// Crear una Grado Instruccion
exports.createGradoInstruccion = async (req, res) => {
  try {
    const gradoinstruccion = await GradoInstruccion.create(req.body);
    logger.info("GradoInstruccions creado correctamente");
    res.status(201).json(gradoinstruccion);
  } catch (error) {
    logger.error("Error al crear un GradoInstruccion: " + error.message);
    res.status(500).json({ error: "Error al crear Grado Instruccion" });
  }
};

// Actualizar una Grado Instruccion
exports.updateGradoInstruccion = async (req, res) => {
  try {
    const gradoinstruccion = await GradoInstruccion.findByPk(req.params.id);
    if (!gradoinstruccion) {
      logger.error("Grado Instruccion no encontrada por su ID");
      return res.status(404).json({ error: "Grado Instruccion no encontrada" });
    }
    await gradoinstruccion.update(req.body);
    logger.info("Grado Instruccion actualizado correctamente");
    res.json(gradoinstruccion);
  } catch (error) {
    logger.error("Error al actualizar un Grado Instruccion: " + error.message);
    res.status(500).json({ error: "Error al actualizar Grado Instruccion" });
  }
};

// Eliminar una Grado Instruccion
exports.deleteGradoInstruccion = async (req, res) => {
  try {
    const gradoinstruccion = await GradoInstruccion.findByPk(req.params.id);
    if (!gradoinstruccion) {
      logger.error("Grado Instruccion no encontrada por su ID");
      return res.status(404).json({ error: "Grado Instruccion no encontrada" });
    }
    await GradoInstruccion.destroy();
    logger.info("Grado Instruccion eliminado correctamente");
    res.json({ message: "Grado Instruccion eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Grado Instruccion: " + error.message);
    res.status(500).json({ error: "Error al eliminar Grado Instruccion" });
  }
};

