const {Hallazgo} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Hallazgoes
exports.getHallazgoAll = async (req, res) => {
  try {
    const hallazgos = await Hallazgo.findAll();
    logger.info("Hallazgos obtenidos correctamente");
    res.json(hallazgos);
  } catch (error) {
    logger.error("Error al obtener Hallazgos: " + error.message);
    res.status(500).json({ error: "Error al obtener Hallazgoes" });
  }
};

// Obtener una Hallazgo por ID
exports.getHallazgoById = async (req, res) => {
  try {
    const hallazgo = await Hallazgo.findByPk(req.params.id);
    if (!hallazgo) {
      logger.error("Hallazgo no encontrada por su ID");
      return res.status(404).json({ error: "Hallazgo no encontrada" });
    }
    logger.info("Hallazgo obtenido correctamente por su ID");
    res.json(hallazgo);
  } catch (error) {
    logger.error("Error al obtener el Hallazgo mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Hallazgo" });
  }
};

// Crear una Hallazgo
exports.createHallazgo = async (req, res) => {
  try {
    const hallazgo = await Hallazgo.create(req.body);
    logger.info("Hallazgos creado correctamente");
    res.status(201).json(hallazgo);
  } catch (error) {
    logger.error("Error al crear un Hallazgo: " + error.message);
    res.status(500).json({ error: "Error al crear Hallazgo" });
  }
};

// Actualizar una Hallazgo
exports.updateHallazgo = async (req, res) => {
  try {
    const hallazgo = await Hallazgo.findByPk(req.params.id);
    if (!hallazgo) {
      logger.error("Hallazgo no encontrada por su ID");
      return res.status(404).json({ error: "Hallazgo no encontrada" });
    }
    await hallazgo.update(req.body);
    logger.info("Hallazgos actualizado correctamente");
    res.json(Hallazgo);
  } catch (error) {
    logger.error("Error al actualizar un Hallazgo: " + error.message);
    res.status(500).json({ error: "Error al actualizar Hallazgo" });
  }
};

// Eliminar una Hallazgo
exports.deleteHallazgo = async (req, res) => {
  try {
    const hallazgo = await Hallazgo.findByPk(req.params.id);
    if (!hallazgo) {
      logger.error("Hallazgo no encontrada por su ID");
      return res.status(404).json({ error: "Hallazgo no encontrada" });
    }
    await Hallazgo.destroy();
    logger.info("Hallazgos eliminado correctamente");
    res.json({ message: "Hallazgo eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Hallazgo: " + error.message);
    res.status(500).json({ error: "Error al eliminar Hallazgo" });
  }
};

