const {HistorialLaboral} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las HistoriaLaborales
exports.getHistoriaLaboralAll = async (req, res) => {
  try {
    const datos = await HistorialLaboral.findAll();
    logger.info("HistoriaLaborals obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener HistoriaLaborals: " + error.message);
    res.status(500).json({ error: "Error al obtener HistoriaLaborales" });
  }
};

// Obtener todas las HistoriaLaborales  por trabajador
exports.getHistoriaLaboralByTrabajador = async (req, res) => {
  try {
    const { trabajador } = req.params;
    const datos = await HistorialLaboral.findAll(
      {
        where: {
          UsuarioId: trabajador
        },
        order: [['FechaFin', 'DESC']] // Ordenar por fecharegistro en orden descendente
      }
    );
    logger.info("HistoriaLaborals obtenidos correctamente");
    res.json(datos);
  } catch (error) {
    logger.error("Error al obtener HistoriaLaborals: " + error.message);
    res.status(500).json({ error: "Error al obtener HistoriaLaborales" });
  }
};

// Obtener una HistoriaLaboral por ID
exports.getHistoriaLaboralById = async (req, res) => {
  try {
    const dato = await HistorialLaboral.findByPk(req.params.id);
    if (!dato) {
      logger.error("HistoriaLaboral no encontrada por su ID");
      return res.status(404).json({ error: "HistoriaLaboral no encontrada" });
    }
    logger.info("HistoriaLaboral obtenido correctamente por su ID");
    res.json(dato);
  } catch (error) {
    logger.error("Error al obtener el HistoriaLaboral mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener HistoriaLaboral" });
  }
};

// Crear una HistoriaLaboral
exports.createHistoriaLaboral = async (req, res) => {
  try {
    const dato = await HistorialLaboral.create(req.body);
    logger.info("HistoriaLaborals creado correctamente");
    res.status(201).json(dato);
  } catch (error) {
    logger.error("Error al crear un HistoriaLaboral: " + error.message);
    res.status(500).json({ error: "Error al crear HistoriaLaboral" });
  }
};

// Actualizar una HistoriaLaboral
exports.updateHistoriaLaboral = async (req, res) => {
  try {
    const dato = await HistorialLaboral.findByPk(req.params.id);
    if (!dato) {
      logger.error("HistoriaLaboral no encontrada por su ID");
      return res.status(404).json({ error: "HistoriaLaboral no encontrada" });
    }
    await dato.update(req.body);
    logger.info("HistoriaLaborals actualizado correctamente");
    res.json(dato);
  } catch (error) {
    logger.error("Error al actualizar un HistoriaLaboral: " + error.message);
    res.status(500).json({ error: "Error al actualizar HistoriaLaboral" });
  }
};

// Eliminar una HistoriaLaboral
exports.deleteHistoriaLaboral = async (req, res) => {
  try {
    const dato = await HistorialLaboral.findByPk(req.params.id);
    if (!dato) {
      logger.error("HistoriaLaboral no encontrada por su ID");
      return res.status(404).json({ error: "HistoriaLaboral no encontrada" });
    }
    await HistoriaLaboral.destroy();
    logger.info("HistoriaLaborals eliminado correctamente");
    res.json({ message: "HistoriaLaboral eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un HistoriaLaboral: " + error.message);
    res.status(500).json({ error: "Error al eliminar HistoriaLaboral" });
  }
};

