const {Iafa} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Iafaes
exports.getIafaAll = async (req, res) => {
  try {
    const iafas = await Iafa.findAll();
    logger.info("Iafas obtenidos correctamente");
    res.json(iafas);
  } catch (error) {
    logger.error("Error al obtener Iafas: " + error.message);
    res.status(500).json({ error: "Error al obtener Iafaes" });
  }
};

// Obtener una IAFA por ID
exports.getIafaById = async (req, res) => {
  try {
    const iafa = await Iafa.findByPk(req.params.id);
    if (!iafa) {
      logger.error("IAFA no encontrada por su ID");
      return res.status(404).json({ error: "IAFA no encontrada" });
    }
    logger.info("Iafa obtenido correctamente por su ID");
    res.json(iafa);
  } catch (error) {
    logger.error("Error al obtener el Iafa mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener IAFA" });
  }
};

// Obtener una IAFA por RUC
exports.getIafaByRUC = async (req, res) => {
  try {
    const { ruc } = req.params; // Asegúrate de que RUC se pasa como parámetro en la ruta
    const iafa = await Iafa.findOne(
      {
        where: {
          RUC: ruc
        }
      }
    );
    if (!iafa) {
      logger.error("IAFA no encontrada por su ID");
      return res.status(404).json({ error: "IAFA no encontrada" });
    }
    logger.info("Iafa obtenido correctamente por su ID");
    res.json(iafa);
  } catch (error) {
    logger.error("Error al obtener el Iafa mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener IAFA" });
  }
};

// Crear una IAFA
exports.createIafa = async (req, res) => {
  try {
    const iafa = await Iafa.create(req.body);
    logger.info("Iafas creado correctamente");
    res.status(201).json(iafa);
  } catch (error) {
    logger.error("Error al crear un Iafa: " + error.message);
    res.status(500).json({ error: "Error al crear IAFA" });
  }
};

// Actualizar una IAFA
exports.updateIafa = async (req, res) => {
  try {
    const iafa = await Iafa.findByPk(req.params.id);
    if (!iafa) {
      logger.error("IAFA no encontrada por su ID");
      return res.status(404).json({ error: "IAFA no encontrada" });
    }
    await iafa.update(req.body);
    logger.info("Iafas actualizado correctamente");
    res.json(iafa);
  } catch (error) {
    logger.error("Error al actualizar un Iafa: " + error.message);
    res.status(500).json({ error: "Error al actualizar IAFA" });
  }
};

// Eliminar una IAFA
exports.deleteIafa = async (req, res) => {
  try {
    const iafa = await Iafa.findByPk(req.params.id);
    if (!iafa) {
      logger.error("IAFA no encontrada por su ID");
      return res.status(404).json({ error: "IAFA no encontrada" });
    }
    await Iafa.destroy();
    logger.info("Iafas eliminado correctamente");
    res.json({ message: "IAFA eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Iafa: " + error.message);
    res.status(500).json({ error: "Error al eliminar IAFA" });
  }
};

