const fs = require('fs').promises;
const path = require('path');
const { Usuario, Paciente, Ubicacion, Agendamiento, 
  Familiar, Covertura, Atiende,
Tarifario, Ingreso, Egreso, ItemTarifario, PresupuestoParcial, PresupuestoTotal,
  Factura, ItemFactura, Facturacion, EmisionFactura, EmisionBoleta } = require('../models'); // Ajusta la ruta según tu estructura

// Método para importar datos desde el archivo JSON a la base de datos
exports.importDataPaciente = async (req, res) => {
  try {
    // Ruta al archivo data.json
    const filePath = path.join(__dirname, '../data', 'datapaciente.json');
    // Lee el archivo JSON
    const fileData = await fs.readFile(filePath, 'utf8');
    // Convierte la cadena JSON a un objeto
    const data = JSON.parse(fileData);
    // Inserta los datos en la nueva base de datos utilizando bulkCreate.
    // Ten en cuenta que, si existen relaciones o restricciones, podrías necesitar ajustar el orden de inserción.
    await Promise.all(
      [
        Paciente.bulkCreate(data.pacientes),
        Familiar.bulkCreate(data.familiares),
        Covertura.bulkCreate(data.coverturas)
      ]
    );
    res.json(
      { 
        message: 'Datos importados exitosamente en la base de datos.'
      }
    );
  } catch (error) {
    console.error('Error importando los datos:', error);
    res.status(500).json(
      {
        error: 'Error importando los datos.'
      }
    );
  }
};

// Método para importar datos desde el archivo JSON a la base de datos
exports.importDataUsuario = async (req, res) => {
  try {
    // Ruta al archivo data.json
    const filePath = path.join(__dirname, '../data', 'datausuario.json');
    // Lee el archivo JSON
    const fileData = await fs.readFile(filePath, 'utf8');
    // Convierte la cadena JSON a un objeto
    const data = JSON.parse(fileData);
    // Inserta los datos en la nueva base de datos utilizando bulkCreate.
    // Ten en cuenta que, si existen relaciones o restricciones, podrías necesitar ajustar el orden de inserción.
    await Promise.all(
      [
        Usuario.bulkCreate(data.usuarios),
        Ubicacion.bulkCreate(data.ubicaciones),
        Atiende.bulkCreate(data.atiendes)
      ]
    );
    res.json(
      { 
        message: 'Datos importados exitosamente en la base de datos.'
      }
    );
  } catch (error) {
    console.error('Error importando los datos:', error);
    res.status(500).json(
      {
        error: 'Error importando los datos.'
      }
    );
  }
};

// Método para importar datos desde el archivo JSON a la base de datos
exports.importDataAgendamiento = async (req, res) => {
  try {
    // Ruta al archivo data.json
    const filePath = path.join(__dirname, '../data', 'dataagedamiento.json');
    // Lee el archivo JSON
    const fileData = await fs.readFile(filePath, 'utf8');
    // Convierte la cadena JSON a un objeto
    const data = JSON.parse(fileData);
    // Inserta los datos en la nueva base de datos utilizando bulkCreate.
    // Ten en cuenta que, si existen relaciones o restricciones, podrías necesitar ajustar el orden de inserción.
    await Promise.all(
      [
        Agendamiento.bulkCreate(data.citas)
      ]
    );
    res.json(
      { 
        message: 'Datos importados exitosamente en la base de datos.'
      }
    );
  } catch (error) {
    console.error('Error importando los datos:', error);
    res.status(500).json(
      {
        error: 'Error importando los datos.'
      }
    );
  }
};

// Método para importar datos desde el archivo JSON a la base de datos
exports.importDataAuditoria = async (req, res) => {
  try {
    // Ruta al archivo data.json
    const filePath = path.join(__dirname, '../data', 'dataauditoria.json');
    // Lee el archivo JSON
    const fileData = await fs.readFile(filePath, 'utf8');
    // Convierte la cadena JSON a un objeto
    const data = JSON.parse(fileData);
    // Inserta los datos en la nueva base de datos utilizando bulkCreate.
    // Ten en cuenta que, si existen relaciones o restricciones, podrías necesitar ajustar el orden de inserción.
    await Promise.all(
      [
        Auditoria.bulkCreate(data.auditorias)
      ]
    );
    res.json(
      { 
        message: 'Datos importados exitosamente en la base de datos.'
      }
    );
  } catch (error) {
    console.error('Error importando los datos:', error);
    res.status(500).json(
      {
        error: 'Error importando los datos.'
      }
    );
  }
};

// Método para importar datos desde el archivo JSON a la base de datos
exports.importDataEconomia1 = async (req, res) => {
  try {
    // Ruta al archivo data.json
    const filePath = path.join(__dirname, '../data', 'dataeconomia.json');
    // Lee el archivo JSON
    const fileData = await fs.readFile(filePath, 'utf8');
    // Convierte la cadena JSON a un objeto
    const data = JSON.parse(fileData);
    // Inserta los datos en la nueva base de datos utilizando bulkCreate.
    // Ten en cuenta que, si existen relaciones o restricciones, podrías necesitar ajustar el orden de inserción.
    await Promise.all(
      [
        Tarifario.bulkCreate(data.tarifarios),
        Ingreso.bulkCreate(data.ingresos),
        Egreso.bulkCreate(data.egresos),
        ItemTarifario.bulkCreate(data.itemstarifario),
        Factura.bulkCreate(data.facturas),
        ItemFactura.bulkCreate(data.itemsfactura)
      ]
    );
    res.json(
      { 
        message: 'Datos importados exitosamente en la base de datos.'
      }
    );
  } catch (error) {
    console.error('Error importando los datos:', error);
    res.status(500).json(
      {
        error: 'Error importando los datos.'
      }
    );
  }
};

// Método para importar datos desde el archivo JSON a la base de datos
exports.importDataEconomia2 = async (req, res) => {
  try {
    // Ruta al archivo data.json
    const filePath = path.join(__dirname, '../data', 'datapresupuesto.json');
    // Lee el archivo JSON
    const fileData = await fs.readFile(filePath, 'utf8');
    // Convierte la cadena JSON a un objeto
    const data = JSON.parse(fileData);
    // Inserta los datos en la nueva base de datos utilizando bulkCreate.
    // Ten en cuenta que, si existen relaciones o restricciones, podrías necesitar ajustar el orden de inserción.
    await Promise.all(
      [
        Facturacion.bulkCreate(data.facturaciones),
        PresupuestoParcial.bulkCreate(data.presupuestosparciales),
        PresupuestoTotal.bulkCreate(data.presupuestostotales),
        EmisionFactura.bulkCreate(data.emisionesdefactura),
        EmisionBoleta.bulkCreate(data.emisionesdeboleta)
      ]
    );
    res.json(
      { 
        message: 'Datos importados exitosamente en la base de datos.'
      }
    );
  } catch (error) {
    console.error('Error importando los datos:', error);
    res.status(500).json(
      {
        error: 'Error importando los datos.'
      }
    );
  }
};