const {Incidencia, Cliente, TipoIncidencia, EstadoIncidencia} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Incidenciaes
exports.getIncidenciaAll = async (req, res) => {
  try {
    const incidencias = await Incidencia.findAll(
      {
        include: [
          {
            model: Cliente,
            as: 'cliente'
          },
          {
            model: TipoIncidencia,
            as: 'tipo'
          },
          {
            model: EstadoIncidencia,
            as: 'estado'
          }
        ]
      }
    );
    logger.info("Incidencias obtenidos correctamente");
    res.json(incidencias);
  } catch (error) {
    logger.error("Error al obtener Incidencias: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidenciaes" });
  }
};

// Obtener una Incidencias por Codigo
exports.getIncidenciaByCodigo = async (req, res) => {
  try {
    const { codigo } = req.params;
    const incidencia = await Incidencia.findByPk(
      {
        where: {
          Codigo: codigo
        },
        include: [
          {
            model: Cliente,
            as: 'cliente'
          },
          {
            model: TipoIncidencia,
            as: 'tipo'
          },
          {
            model: EstadoIncidencia,
            as: 'estado'
          }
        ]
      }
    );
    if (!incidencia) {
      logger.error("Incidencias no encontradas por su Estado");
      return res.status(404).json({ error: "Incidencias no encontradas" });
    }
    logger.info("Incidencias obtenidas correctamente por su Estado");
    res.json(incidencia);
  } catch (error) {
    logger.error("Error al obtener el Incidencias mediante su Estado: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencias" });
  }
};

// Obtener una Incidencias por personal
exports.getIncidenciaByPersonal = async (req, res) => {
  try {
    const { personal } = req.params;
    const incidencias = await Incidencia.findAll(
      {
        where: {
          DOCPersonal: personal
        },
        include: [
          {
            model: Cliente,
            as: 'cliente'
          },
          {
            model: TipoIncidencia,
            as: 'tipo'
          },
          {
            model: EstadoIncidencia,
            as: 'estado'
          }
        ]
      }
    );
    if (!incidencias) {
      logger.error("Incidencias no encontradas por su Estado");
      return res.status(404).json({ error: "Incidencias no encontradas" });
    }
    logger.info("Incidencias obtenidas correctamente por su Estado");
    res.json(incidencias);
  } catch (error) {
    logger.error("Error al obtener el Incidencias mediante su Estado: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencias" });
  }
};

// Obtener una Incidencias por Sede
exports.getIncidenciaBySede = async (req, res) => {
  try {
    const { sede } = req.params;
    const incidencias = await Incidencia.findAll(
      {
        where: {
          SedeId: sede
        },
        include: [
          {
            model: Cliente,
            as: 'cliente'
          },
          {
            model: TipoIncidencia,
            as: 'tipo'
          },
          {
            model: EstadoIncidencia,
            as: 'estado'
          }
        ]
      }
    );
    if (!incidencias) {
      logger.error("Incidencias no encontradas por su Estado");
      return res.status(404).json({ error: "Incidencias no encontradas" });
    }
    logger.info("Incidencias obtenidas correctamente por su Estado");
    res.json(incidencias);
  } catch (error) {
    logger.error("Error al obtener el Incidencias mediante su Estado: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencias" });
  }
};

// Obtener una Incidencias por Sede y Tipo
exports.getIncidenciaBySedeyTipo = async (req, res) => {
  try {
    const { sede, tipo } = req.params;
    const incidencias = await Incidencia.findAll(
      {
        where: {
          SedeId: sede,
          TipoIncidenciaId: tipo
        },
        include: [
          {
            model: Cliente,
            as: 'cliente'
          },
          {
            model: TipoIncidencia,
            as: 'tipo'
          },
          {
            model: EstadoIncidencia,
            as: 'estado'
          }
        ]
      }
    );
    if (!incidencias) {
      logger.error("Incidencias no encontradas por su Estado");
      return res.status(404).json({ error: "Incidencias no encontradas" });
    }
    logger.info("Incidencias obtenidas correctamente por su Estado");
    res.json(incidencias);
  } catch (error) {
    logger.error("Error al obtener el Incidencias mediante su Estado: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencias" });
  }
};

// Obtener una Incidencias por Sede, Tipo y Estado
exports.getIncidenciaBySedeTipoyEstado = async (req, res) => {
  try {
    const { sede, tipo, estado } = req.params;
    const incidencias = await Incidencia.findAll(
      {
        where: {
          SedeId: sede,
          TipoIncidenciaId: tipo,
          EstadoId: estado
        },
        include: [
          {
            model: Cliente,
            as: 'cliente'
          },
          {
            model: TipoIncidencia,
            as: 'tipo'
          },
          {
            model: EstadoIncidencia,
            as: 'estado'
          }
        ]
      }
    );
    if (!incidencias) {
      logger.error("Incidencias no encontradas por su Estado");
      return res.status(404).json({ error: "Incidencias no encontradas" });
    }
    logger.info("Incidencias obtenidas correctamente por su Estado");
    res.json(incidencias);
  } catch (error) {
    logger.error("Error al obtener el Incidencias mediante su Estado: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencias" });
  }
};

// Obtener una Incidencia por ID
exports.getIncidenciaById = async (req, res) => {
  try {
    const incidencia = await Incidencia.findByPk(req.params.id);
    if (!incidencia) {
      logger.error("Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia no encontrada" });
    }
    logger.info("Incidencia obtenido correctamente por su ID");
    res.json(incidencia);
  } catch (error) {
    logger.error("Error al obtener el Incidencia mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencia" });
  }
};

// Crear una Incidencia
exports.createIncidencia = async (req, res) => {
  try {
    const incidencia = await Incidencia.create(req.body);
    logger.info("Incidencias creado correctamente");
    res.status(201).json(incidencia);
  } catch (error) {
    logger.error("Error al crear un Incidencia: " + error.message);
    res.status(500).json({ error: "Error al crear Incidencia" });
  }
};

// Actualizar una Incidencia
exports.updateIncidencia = async (req, res) => {
  try {
    const incidencia = await Incidencia.findByPk(req.params.id);
    if (!incidencia) {
      logger.error("Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia no encontrada" });
    }
    await incidencia.update(req.body);
    logger.info("Incidencias actualizado correctamente");
    res.json(incidencia);
  } catch (error) {
    logger.error("Error al actualizar un Incidencia: " + error.message);
    res.status(500).json({ error: "Error al actualizar Incidencia" });
  }
};

// Eliminar una Incidencia
exports.deleteIncidencia = async (req, res) => {
  try {
    const incidencia = await Incidencia.findByPk(req.params.id);
    if (!incidencia) {
      logger.error("Incidencia no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia no encontrada" });
    }
    await Incidencia.destroy();
    logger.info("Incidencias eliminado correctamente");
    res.json({ message: "Incidencia eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Incidencia: " + error.message);
    res.status(500).json({ error: "Error al eliminar Incidencia" });
  }
};

