const {IncidenciaDetalle} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las IncidenciaDetallees
exports.getIncidenciaDetalleAll = async (req, res) => {
  try {
    const IncidenciaDetalles = await IncidenciaDetalle.findAll(
      {
        include: [
          {
            model: Incidencia,
            as: 'incidencia'
          }
        ]
      }
    );
    logger.info("IncidenciaDetalles obtenidos correctamente");
    res.json(IncidenciaDetalles);
  } catch (error) {
    logger.error("Error al obtener IncidenciaDetalles: " + error.message);
    res.status(500).json({ error: "Error al obtener IncidenciaDetallees" });
  }
};

// Obtener una Incidencia Detalle por Incidencia
exports.getIncidenciaDetalleByIncidencia = async (req, res) => {
  try {
    const { incidencia } = req.params;
    const incidenciadetalle = await IncidenciaDetalle.findAll(
      {
        where: {
          IncidenciaId: incidencia
        }
      }
    );
    if (!incidenciadetalle) {
      logger.error("Incidencia Detalle no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia Detalle no encontrada" });
    }
    logger.info("IncidenciaDetalle obtenido correctamente por su ID");
    res.json(incidenciadetalle);
  } catch (error) {
    logger.error("Error al obtener el IncidenciaDetalle mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencia Detalle" });
  }
};

// Obtener una Incidencia Detalle por ID
exports.getIncidenciaDetalleById = async (req, res) => {
  try {
    const incidenciadetalle = await IncidenciaDetalle.findByPk(req.params.id);
    if (!incidenciadetalle) {
      logger.error("Incidencia Detalle no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia Detalle no encontrada" });
    }
    logger.info("IncidenciaDetalle obtenido correctamente por su ID");
    res.json(incidenciadetalle);
  } catch (error) {
    logger.error("Error al obtener el IncidenciaDetalle mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Incidencia Detalle" });
  }
};

// Crear una Incidencia Detalle
exports.createIncidenciaDetalle = async (req, res) => {
  try {
    const incidenciadetalle = await IncidenciaDetalle.create(req.body);
    logger.info("IncidenciaDetalles creado correctamente");
    res.status(201).json(incidenciadetalle);
  } catch (error) {
    logger.error("Error al crear un IncidenciaDetalle: " + error.message);
    res.status(500).json({ error: "Error al crear Incidencia Detalle" });
  }
};

// Actualizar una Incidencia Detalle
exports.updateIncidenciaDetalle = async (req, res) => {
  try {
    const incidenciadetalle = await IncidenciaDetalle.findByPk(req.params.id);
    if (!incidenciadetalle) {
      logger.error("Incidencia Detalle no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia Detalle no encontrada" });
    }
    await incidenciadetalle.update(req.body);
    logger.info("IncidenciaDetalles actualizado correctamente");
    res.json(IncidenciaDetalle);
  } catch (error) {
    logger.error("Error al actualizar un IncidenciaDetalle: " + error.message);
    res.status(500).json({ error: "Error al actualizar Incidencia Detalle" });
  }
};

// Eliminar una Incidencia Detalle
exports.deleteIncidenciaDetalle = async (req, res) => {
  try {
    const incidenciadetalle = await IncidenciaDetalle.findByPk(req.params.id);
    if (!incidenciadetalle) {
      logger.error("Incidencia Detalle no encontrada por su ID");
      return res.status(404).json({ error: "Incidencia Detalle no encontrada" });
    }
    await IncidenciaDetalle.destroy();
    logger.info("IncidenciaDetalles eliminado correctamente");
    res.json({ message: "Incidencia Detalle eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un IncidenciaDetalle: " + error.message);
    res.status(500).json({ error: "Error al eliminar Incidencia Detalle" });
  }
};

