const bcrypt = require('bcryptjs');
const {
  sequelize,
  EstadoAgendamiento,
  EstadoIncidencia,
  EstadoPago,
  EstadoUsuario,
  FuenteCaptacion,
  Genero,
  GradoInstruccion,
  Relacion,
  Vinculacion,
  TipoAfiliacion,
  TipoIncidencia,
  TipoPago,
  TipoUsuario,
  EstadoCampania,
  EstadoOrdenLaboratorio,
  Periodo,
  TipoActividad,
  TipoCampania,
  TipoIngreso,
  TipoProveedor,
  TipoRespuesta,
  Servicio,
  Profesion,
  CargoUsuario,
  TipoDocumento,
  Empresa,
  Sede,
  Iafa,
  // modelos de datos para RRHH
  TipoDocPDF,
  // modelos de datos para patrimonio
  CategoriaPatrimonio,
  SubCategoriaPatrimonio,
  // modelos de datos para inventario
  Almacen,
  CategoriaInventario,
  SubCategoriaInventario,
  // modelos para radiografia
  Radiografia, EmpresaRadiografia, ItemRadiografia,
  //modelos para laboratorio
  Laboratorio, EmpresaLaboratorio, 
  ItemLaboratorio, SubItemLaboratorio,
  // modelo para los hallazgos
  Categoria, Hallazgo, Catalogo, Tarifario, Procedimiento,
  // tablas independientes
  TipoDiente,
  Cuadrante,
  Ubicacion,
  TipoConcentimiento,
    Usuario, Paciente,
    Diagnostico,
  // tablas dependientes
  Diente, EstadoDiente,
} = require('../models');
// Datos fijos a insertar
// datos de estados de agendamiento
const estadosagendamiento = [
  { Nombre: 'Agendado' },
  { Nombre: 'Notificado' },
  { Nombre: 'Confirmado' },
  { Nombre: 'Cancelado' },
  { Nombre: 'Reprogramar' },
  { Nombre: 'No Asistio' },
  { Nombre: 'Atendiendose' },
  { Nombre: 'Atendido' },
  { Nombre: 'No Disponible' }
];
// datos estado de incidencia
const estadosincidencia = [
  { Nombre: 'Solicitada' },
  { Nombre: 'Verificacion' },
  { Nombre: 'Seguimiento' },
  { Nombre: 'Accionar' },
  { Nombre: 'Finalizado' }
];
// datos estado de usuario
// para cambiar la contrasenia
const estadosusuario = [
  { Nombre: 'Deshabilitado' },
  { Nombre: 'Habilitado' }
];
// datos fuentes de captacion
const fuentescaptacion = [
  { Nombre: 'Faceebook' },
  { Nombre: 'Instagram' },
  { Nombre: 'TikTok' },
  { Nombre: 'You Tube' },
  { Nombre: 'Amigos' },
  { Nombre: 'Familiares' },
  { Nombre: 'Web' },
  { Nombre: 'Otro' }
];
// datos generos
const generos = [
  { Nombre: 'Masculino' },
  { Nombre: 'Femenino' },
  { Nombre: 'Otros' }
];
// datos grados de instruccion
const gradosdeinstruccion = [
  { Nombre: 'Analfabeto' },
  {
    Nombre: 'Inicial Incompleto'
  },
  {
    Nombre: 'Inicial Completo'
  },
  {
    Nombre: 'Primaria Incompleta'
  },
  {
    Nombre: 'Primaria Completo'
  },
  {
    Nombre: 'Secundaria Incompleta'
  },
  {
    Nombre: 'Secundaria Completo'
  },
  {
    Nombre: 'Superior Tecnico Incompleta'
  },
  {
    Nombre: 'Superior Tecnico Completo'
  },
  {
    Nombre: 'Superior Universitario Incompleta'
  },
  {
    Nombre: 'Superior Universitario Completo'
  },
  {
    Nombre: 'Maestria'
  },
  {
    Nombre: 'Doctorado'
  },
  {
    Nombre: 'Post-Doctorado'
  }
];
// datos relaciones interpersonales
const relaciones = [
  {
    Nombre: 'Padre'
  },
  {
    Nombre: 'Madre'
  },
  {
    Nombre: 'Hijo'
  },
  {
    Nombre: 'Hija'
  },
  {
    Nombre: 'Hermano'
  },
  {
    Nombre: 'Hermana'
  },
  {
    Nombre: 'Pareja'
  },
  {
    Nombre: 'Esposo'
  },
  {
    Nombre: 'Esposa'
  },
  {
    Nombre: 'Abuelo'
  },
  {
    Nombre: 'Abuela'
  },
  {
    Nombre: 'Nieto'
  },
  {
    Nombre: 'Nieta'
  },
  {
    Nombre: 'Tío'
  },
  {
    Nombre: 'Tía'
  },
  {
    Nombre: 'Sobrino'
  },
  {
    Nombre: 'Sobrina'
  },
  {
    Nombre: 'Primo'
  },
  {
    Nombre: 'Prima'
  },
  {
    Nombre: 'Suegro'
  },
  {
    Nombre: 'Suegra'
  },
  {
    Nombre: 'Yerno'
  },
  {
    Nombre: 'Nuera'
  },
  {
    Nombre: 'Cuñado'
  },
  {
    Nombre: 'Cuñada'
  },
  {
    Nombre: 'Padrastro'
  },
  {
    Nombre: 'Madrastra'
  },
  {
    Nombre: 'Hermanastro'
  },
  {
    Nombre: 'Hermanastra'
  },
  {
    Nombre: 'Hijastro'
  },
  {
    Nombre: 'Hijastra'
  },
  {
    Nombre: 'Vecino(a)'
  },
  {
    Nombre: 'Apoderado'
  },
  {
    Nombre: 'Otro'
  }
];
// datos vinculacion empresarial
const vinculaciones = [
  {
    Nombre: 'Planilla'
  },
  {
    Nombre: 'Contratado'
  },
  {
    Nombre: 'Practicante'
  },
  {
    Nombre: 'Desvinculado'
  }
];
// datos tipo afiliacion a iafa
const tiposafiliacion = [
  {
    Nombre: 'Titular'
  },
  {
    Nombre: 'Adherente'
  }
];
// datos tipo incidencia
const tiposincidencia = [
  {
    Nombre: 'Reclamo'
  },
  {
    Nombre: 'Queja'
  },
  {
    Nombre: 'Recomendacion'
  },
];
// datos tipo pago
const tipospago = [
  {
    Nombre: 'Efectivo'
  },
  {
    Nombre: 'Efectivo - moneda extranjera'
  },
  {
    Nombre: 'Tarjeta (VISA, CMR, etc)'
  },
  {
    Nombre: 'Transferencia bancaria'
  },
  {
    Nombre: 'Deposito bancaria'
  },
  {
    Nombre: 'Yape'
  },
  {
    Nombre: 'Plin'
  },
  {
    Nombre: 'Pago con billetera digital'
  },
  {
    Nombre: 'Proyecto Peregrino'
  },
  {
    Nombre: 'Reembolso'
  },
];
// datos tipo proveedor o quien aporto
const tiposproveedor = [
  {
    Nombre: 'Paciente'
  },
  {
    Nombre: 'Alquiler'
  },
  {
    Nombre: 'Aseguradora'
  },
  {
    Nombre: 'Otro'
  }
];
// datos tipo de ingreso
const tiposingreso = [
  {
    Nombre: 'Factura'
  },
  {
    Nombre: 'Boleta'
  },
  {
    Nombre: 'Ninguno'
  },
  {
    Nombre: 'Aseguradora'
  }
];
// datos estado de pago
const estadospago = [
  {
    Nombre: 'Pendiente'
  },
  {
    Nombre: 'Pagado'
  },
  {
    Nombre: 'Reembolsado'
  },
  {
    Nombre: 'Pagado - Parcial'
  }
];
// datos estado orden de laboratorio
const estadosordendelaboratorio = [
  {
    Nombre: 'Solicitada'
  },
  {
    Nombre: 'Resultados listos'
  },
  {
    Nombre: 'Disponible para entrega'
  },
  {
    Nombre: 'Entregado'
  }
];
// datos para campania
// datos tipos de campania
const tiposdecampania = [
  {
    Nombre: 'Campañas de Captación de Nuevos Pacientes'
  },
  {
    Nombre: 'Campañas de Fidelización'
  },
  {
    Nombre: 'Campañas de Temporada'
  },
  {
    Nombre: 'Campañas de Servicios Específicos'
  },
  {
    Nombre: 'Campañas Educativas y de Concienciación'
  },
  {
    Nombre: 'Campañas Aniversario del paciente'
  }
];
// datos estados de campania
const estadosdecampania = [
  {
    Nombre: 'Promocion'
  },
  {
    Nombre: 'Activa'
  },
  {
    Nombre: 'Finalizada'
  },
  {
    Nombre: 'Expirada'
  }
];
// datos tipos de actividad
const tiposdeactividad = [
  {
    Nombre: 'Actividades Clínicas (Atención al Paciente)'
  },
  {
    Nombre: 'Actividades de Educación y Prevención'
  },
  {
    Nombre: 'Actividades de Marketing y Promoción'
  },
];
// datos tipo de respuesta
const tiposderesponsa = [
  {
    Nombre: 'Respuestas Positivas ✅'
  },
  {
    Nombre: 'Respuestas Neutrales ⚖'
  },
  {
    Nombre: 'Respuestas Negativas ❌'
  }
];
// datos tipo documento
const tiposdocumento = [
  {
    Nombre: 'DNI',
    Digitos: 8
  },
  {
    Nombre: 'CE',
    Digitos: 12
  },
  {
    Nombre: 'RUC',
    Digitos: 11
  },
  {
    Nombre: 'PASAPORTE',
    Digitos: 10  
  },
  {
    Nombre: 'NO DOCUMENTO (AUTOGENERADO)',
    Digitos: 15
  },
];
// datos para los periodos
const periodos = [
  {
    Nombre: '2025-06',
    Anio: '2025',
    Mes: '06'
  },
  {
    Nombre: '2025-07',
    Anio: '2025',
    Mes: '07'
  },
  {
    Nombre: '2025-08',
    Anio: '2025',
    Mes: '08'
  },
  {
    Nombre: '2025-09',
    Anio: '2025',
    Mes: '09'
  },
  {
    Nombre: '2025-10',
    Anio: '2025',
    Mes: '10'
  },
  {
    Nombre: '2025-11',
    Anio: '2025',
    Mes: '11'
  },
  {
    Nombre: '2025-12',
    Anio: '2025',
    Mes: '12'
  }
];
// datos tipo usuario
const tiposusuario = [
  {
    Nombre: 'Administrador Global'
  },
  {
    Nombre: 'Ingeniero'
  },
  {
    Nombre: 'Administrador Sede'
  },
  {
    Nombre: 'Recepcionista'
  },
  {
    Nombre: 'Asistente'
  },
  {
    Nombre: 'Odontólogo'
  },
  {
    Nombre: 'Logística'
  },
  {
    Nombre: 'Radiografia'
  },
  {
    Nombre: 'Laboratorio'
  },
  {
    Nombre: 'Recursos Humanos'
  },
  {
    Nombre: 'Contabilidad'
  },
  {
    Nombre: 'Marketing y Comunicación'
  },
  {
    Nombre: 'Otros'
  },
];
// datos cargo usuario
const cargosusuario = [
  {
    Nombre: 'Dirección o Gerencia',
    Funcion: 'Acceso Total a Todos los Dashboard'
  },
  {
    Nombre: 'Tecnologías de la Información (TI)',
    Funcion: 'Funcionamiento de la Aplicacion'
  },
  {
    Nombre: 'Administración y Finanzas',
    Funcion: 'Acceso Total por Sede'
  },
  {
    Nombre: 'Servicio al Cliente',
    Funcion: 'Agendamiento, HC, Odontograma'
  },
  {
    Nombre: 'Logística y Cadena de Suministro',
    Funcion: 'Insumos y Patrimonio'
  },
  {
    Nombre: 'Recursos Humanos',
    Funcion: 'Legajos, Satisfaccion e Incidencias'
  },
  {
    Nombre: 'Marketing y Comunicación',
    Funcion: 'Promocionar Campanias'
  },
  {
    Nombre: 'Odontología',
    Funcion: 'Agendamiento, HC, Odontograma'
  },
  {
    Nombre: 'Radiografia',
    Funcion: 'Radiografias, HC, Odontograma'
  },
  {
    Nombre: 'Laboratorio',
    Funcion: 'Analisis de laboratorio'
  },
];
// datos servicios
const servicios = [
  {
    Nombre: 'Consulta Odontológica',
    Descripcion: 'Evaluación general de la salud bucal para diagnóstico y planificación de tratamiento.',
    Foto: ''
  },
  {
    Nombre: 'Radiografía Periapical',
    Descripcion: 'Imagen dental que muestra la raíz y hueso alrededor de un diente específico.',
    Foto: ''
  },
  {
    Nombre: 'Exodoncia',
    Descripcion: 'Extracción o remoción de un diente dañado o problemático.',
    Foto: ''
  },
  {
    Nombre: 'Profilaxis',
    Descripcion: 'Limpieza profesional para eliminar placa y sarro, previniendo enfermedades dentales.',
    Foto: ''
  },
  {
    Nombre: 'Apicectomía',
    Descripcion: 'Cirugía para eliminar la punta de la raíz dental infectada.',
    Foto: ''
  },
  {
    Nombre: 'Pulpotomía',
    Descripcion: 'Tratamiento que elimina la parte afectada de la pulpa dental en dientes temporales.',
    Foto: ''
  },
  {
    Nombre: 'Pulpectomía',
    Descripcion: 'Remoción completa de la pulpa dental infectada o dañada.',
    Foto: ''
  },
  {
    Nombre: 'Obturación con resina simple',
    Descripcion: 'Restauración dental con resina para reparar cavidades pequeñas.',
    Foto: ''
  },
  {
    Nombre: 'Obturación con resina compleja',
    Descripcion: 'Restauración con resina para cavidades más extensas o complejas.',
    Foto: ''
  },
  {
    Nombre: 'Radiografía Panorámica',
    Descripcion: 'Imagen amplia que muestra toda la boca, incluyendo dientes, mandíbula y maxilares.',
    Foto: ''
  },
  {
    Nombre: 'Aplicación de Flúor',
    Descripcion: 'Tratamiento para fortalecer el esmalte dental y prevenir caries.',
    Foto: ''
  },
  {
    Nombre: 'Blanqueamiento',
    Descripcion: 'Procedimiento para aclarar el color de los dientes y mejorar su estética.',
    Foto: ''
  },
  {
    Nombre: 'Carillas',
    Descripcion: 'Láminas delgadas colocadas sobre los dientes para mejorar su forma y color.',
    Foto: ''
  },
  {
    Nombre: 'Corona Dental',
    Descripcion: 'Cubierta que protege y restaura un diente dañado o debilitado.',
    Foto: ''
  },
  {
    Nombre: 'Prótesis Dentales',
    Descripcion: 'Dispositivos removibles o fijos que reemplazan dientes ausentes para restaurar función y estética.',
    Foto: ''
  },
];
// datos profesiones
const profesiones = [
  {
    Nombre: 'Odontologia Estetica y Rehabilitacion',
    Descripcion: 'Especialidad enfocada en mejorar la apariencia y función dental mediante tratamientos estéticos y restaurativos.',
    Imagen: ''
  },
  {
    Nombre: 'Odontopediatria',
    Descripcion: 'Cuidado dental especializado para niños, promoviendo la salud oral desde la infancia.',
    Imagen: ''
  },
  {
    Nombre: 'Odontologia Integral',
    Descripcion: 'Atención dental completa que abarca prevención, diagnóstico y tratamiento de diversas patologías bucales.',
    Imagen: ''
  },
  {
    Nombre: 'Ortodoncia y Ortopedia',
    Descripcion: 'Corrección de la posición dental y desarrollo óseo facial para mejorar la mordida y estética.',
    Imagen: ''
  },
  {
    Nombre: 'Odontologia General',
    Descripcion: 'Servicios básicos de salud dental para mantener y restaurar la salud bucal.',
    Imagen: ''
  },
  {
    Nombre: 'Implantes y Cirugia Maxilofacial',
    Descripcion: 'Procedimientos quirúrgicos para la colocación de implantes dentales y tratamiento de afecciones maxilofaciales.',
    Imagen: ''
  }
];
// datos iafas
const iafas = [
  {
    RazonSocial: 'Rimac Seguros y Reaseguros',
    RUC: '20100041953',
    Direccion: 'Cal. el Parque Nro. 149 Int. Pis2',
    Contacto: '',
    FechaCacelacion: ''
  },
  {
    RazonSocial: 'Mapfre Peru Compañia de Seguros y Reaseguros',
    RUC: '20418896915',
    Direccion: 'Av. Armendariz Nro. 345',
    Contacto: '',
    FechaCacelacion: ''
  },
  {
    RazonSocial: 'Pacifico Compañia de Seguros y Reaseguros',
    RUC: '20332970411',
    Direccion: 'AV. JUAN DE ARONA OTR. CENTRO EMPRESARIAL SAN IS 830 SAN ISIDRO - LIMA - LIMA',
    Contacto: '',
    FechaCacelacion: ''
  },
  {
    RazonSocial: 'SANITAS PERU S.A. - EPS',
    RUC: '20523470761',
    Direccion: 'AV. RICARDO RIVERA NAVARRETE URB. JARDIN 543 SAN ISIDRO - LIMA - LIMA',
    Contacto: '',
    FechaCacelacion: ''
  },
  {
    RazonSocial: 'Sigma Dental',
    RUC: '20519133530',
    Direccion: 'AV. CAMINO REAL 1225 INT 402 SAN ISIDRO - LIMA - LIMA',
    Contacto: '',
    FechaCacelacion: ''
  },
  {
    RazonSocial: 'Particular',
    RUC: '00000000000',
    Direccion: 'S/D',
    Contacto: 'Ninguno',
    FechaCacelacion: 'Por Siempre'
  },
];
// datos empresas
const empresas = [
  {
    RazonSocial: 'Clinica Dental Imagen SAC',
    NombreComercial: 'C.O. Imagen',
    RUC: '20486238322',
    TipoEmpresa: 'Privada',
    Sector: 'Salud',
    SitioWeb: 'https://clinicadentalimagen.pe/',
    Facebook: 'https://www.facebook.com/clinicadentalimagen.sac',
    Instagram: 'https://www.instagram.com/clinicadentalimagenoficial/',
    TikTok: 'https://www.tiktok.com/@clinicadentalimagen',
    YouTube: '',
    Correo: 'clinicadentalimagensac@gmail.com',
    Telefono: '',
    Celular: ''
  }
];
// datos sedes
const sedes = [
  {
    Nombre: 'Sede Principal - Huancayo - El Tambo',
    TipoSede: 'Principal',
    Direccion: 'Calle Real Nº 716 - 2do Piso El Tambo – Huancayo',
    Referencia: 'Costado de la DIRESA',
    Telefono: '(064)249898',
    Celular: '932050033',
    Encargado: '',
    Foto: '',
    EmpresaId: 1
  },
  {
    Nombre: 'Sucursal - Huancayo - Huancayo',
    TipoSede: 'Sucursal',
    Direccion: 'Calle Real Nº 688 – 3er Piso - Huancayo',
    Referencia: '1/2 cuadra del Gobierno Regional Junin',
    Telefono: '(064) 212331',
    Celular: '',
    Encargado: '',
    Foto: '',
    EmpresaId: 1
  },
  {
    Nombre: 'Sucursal2 - Huancayo - Huancayo',
    TipoSede: 'Sucursal',
    Direccion: 'Clínica Ortega (Av. Daniel Alcides Carrión Nº 1124 – Huancayo) 4to Piso',
    Referencia: 'Clínica Ortega',
    Telefono: '( 064) 235430 Anexo 405',
    Celular: '',
    Encargado: '',
    Foto: '',
    EmpresaId: 1
  },
  {
    Nombre: 'Sucursal - Lima - Santiago de Surco',
    TipoSede: 'Sucursal',
    Direccion: 'Av. Circunvalación del Club Golf Los Incas N° 134 Of. 1603 Edificio Panorama - Santiago de Surco - Lima',
    Referencia: 'Edificio Panorama',
    Telefono: '',
    Celular: '944161660',
    Encargado: '',
    Foto: '',
    EmpresaId: 1
  },
];
// datos de radiografias (radiografias, empresas radiografias, items radiografias)
// datos de radiografia
const radiografias = [
  { Nombre: 'Intraorales' },
  { Nombre: 'Extraorales' },
  { Nombre: 'Diagnóstico' },
  { Nombre: 'Endodoncia' },
  { Nombre: 'Ortodoncia' }
];
// datos de empresas radiografias
const empresasradiografia = [
  {
    Nombre: 'Radiografias SAC', 
    RUC: '20486238322', 
    Direccion: 'Calle Real Nº 716 - 2do Piso El Tambo – Huancayo', 
    Celular: '', 
    Correo: ''
  }
];
// datos de items radiografias
const itemsradiografia = [
  { RadiografiaId: 1, Nombre: 'Radiografía periapical'},
  { RadiografiaId: 1, Nombre: 'Radiografía oclusal'},
  { RadiografiaId: 1, Nombre: 'Radiografía bitewing'},
  { RadiografiaId: 2, Nombre: 'Radiografía panorámica'},
  { RadiografiaId: 2, Nombre: 'Tomografía computarizada de cono-beam'},
  { RadiografiaId: 2, Nombre: 'Radiografía cefalométrica lateral'},
  { RadiografiaId: 3, Nombre: 'Radiografía para evaluación de implantes'},
  { RadiografiaId: 3, Nombre: 'Radiografía para evaluación de caries'},
  { RadiografiaId: 3, Nombre: 'Radiografía para evaluación de abscesos'},
  { RadiografiaId: 4, Nombre: 'Radiografía para diagnóstico de conductos'},
  { RadiografiaId: 4, Nombre: 'Radiografía post-tratamiento de conductos'},
  { RadiografiaId: 5, Nombre: 'Radiografía para planificación de tratamiento ortodóntico'},
  { RadiografiaId: 5, Nombre: 'Radiografía de seguimiento ortodóntico'},
];
// datos de laboratorio (laboratorios, empresas laboratorio, items laboratorio, subitems laboratorio)
// datos de laboratorio
const laboratorios = [
  { Nombre: 'Hematología' },
  { Nombre: 'Bioquímica' },
  { Nombre: 'Microbiología' },
  { Nombre: 'Inmunología' }
];
// datos de empresas laboratorio
const empresaslaboratorio = [
  {
    Nombre: 'Laboratorio Dental SAC', 
    RUC: '20486238322', 
    Direccion: 'Calle Real Nº 716 - 2do Piso El Tambo – Huancayo', 
    Celular: '', 
    Correo: ''
  }
];
// datos de items laboratorio
const itemslaboratorio = [
  // Hematología
  { Nombre: 'Hemograma completo', LaboratorioId: 1 },
  { Nombre: 'Recuento de plaquetas', LaboratorioId: 1 },
  { Nombre: 'Velocidad de sedimentación globular (VSG)', LaboratorioId: 1 },
  { Nombre: 'Coagulación', LaboratorioId: 1 },
  // Bioquímica
  { Nombre: 'Perfil lipídico', LaboratorioId: 2 },
  { Nombre: 'Perfil tiroideo', LaboratorioId: 2 },
  { Nombre: 'Función hepática', LaboratorioId: 2 },
  { Nombre: 'Electrolitos', LaboratorioId: 2 },
  // Uroanálisis
  { Nombre: 'Análisis general de orina', LaboratorioId: 3 },
  { Nombre: 'Cultivo de orina', LaboratorioId: 3 },
  { Nombre: 'Urocultura', LaboratorioId: 3 },
  { Nombre: 'Análisis de sedimento de orina', LaboratorioId: 3 },
  // Inmunología
  { Nombre: 'Serología para COVID-19', LaboratorioId: 4 },
  { Nombre: 'Anticuerpos anti-HIV', LaboratorioId: 4 },
  { Nombre: 'Factor Reumatoide', LaboratorioId: 4 },
  { Nombre: 'Pruebas de alergias', LaboratorioId: 4 },
];
// datos de subitems laboratorio
const subitemslaboratorio = [
  // Hematología
  { Nombre: 'Hemoglobina', UnidaddeMedida: 'g/dL', ValorReferencial: '12-16', ItemLaboratorioId: 1 },
  { Nombre: 'Hematocrito', UnidaddeMedida: '%', ValorReferencial: '36-46', ItemLaboratorioId: 1 },
  { Nombre: 'Recuento de glóbulos blancos', UnidaddeMedida: 'x10^3/µL', ValorReferencial: '4.5-11', ItemLaboratorioId: 1 },
  { Nombre: 'Recuento de reticulocitos', UnidaddeMedida: '%', ValorReferencial: '0.5-2.5', ItemLaboratorioId: 1 },
  { Nombre: 'Plaquetas', UnidaddeMedida: 'x10^3/µL', ValorReferencial: '150-450', ItemLaboratorioId: 2 },
  { Nombre: 'VSG', UnidaddeMedida: 'mm/hr', ValorReferencial: '0-20', ItemLaboratorioId: 3 },
  { Nombre: 'Tiempo de protrombina (PT)', UnidaddeMedida: 'segundos', ValorReferencial: '11-13.5', ItemLaboratorioId: 4 },
  { Nombre: 'Tiempo de tromboplastina parcial (PTT)', UnidaddeMedida: 'segundos', ValorReferencial: '25-35', ItemLaboratorioId: 4 },
  { Nombre: 'Fibrinógeno', UnidaddeMedida: 'mg/dL', ValorReferencial: '200-400', ItemLaboratorioId: 4 },
  { Nombre: 'D-dímero', UnidaddeMedida: 'ng/mL', ValorReferencial: '<500', ItemLaboratorioId: 4 },
  // Bioquímica
  { Nombre: 'Colesterol total', UnidaddeMedida: 'mg/dL', ValorReferencial: '<200', ItemLaboratorioId: 5 },
  { Nombre: 'Colesterol HDL', UnidaddeMedida: 'mg/dL', ValorReferencial: '>40', ItemLaboratorioId: 5 },
  { Nombre: 'Colesterol LDL', UnidaddeMedida: 'mg/dL', ValorReferencial: '<100', ItemLaboratorioId: 5 },
  { Nombre: 'Triglicéridos', UnidaddeMedida: 'mg/dL', ValorReferencial: '<150', ItemLaboratorioId: 5 },
  { Nombre: 'Tiroxina (T4)', UnidaddeMedida: 'µg/dL', ValorReferencial: '4.5-12', ItemLaboratorioId: 6 },
  { Nombre: 'Tiroxina libre (fT4)', UnidaddeMedida: 'ng/dL', ValorReferencial: '0.9-1.7', ItemLaboratorioId: 6 },
  { Nombre: 'Tirotroptina (TSH)', UnidaddeMedida: 'µIU/mL', ValorReferencial: '0.4-4.0', ItemLaboratorioId: 6 },
  { Nombre: 'Transaminasa ALT', UnidaddeMedida: 'U/L', ValorReferencial: '7-56', ItemLaboratorioId: 7 },
  { Nombre: 'Transaminasa AST', UnidaddeMedida: 'U/L', ValorReferencial: '8-48', ItemLaboratorioId: 7 },
  { Nombre: 'Gama GT', UnidaddeMedida: 'U/L', ValorReferencial: '9-48', ItemLaboratorioId: 7 },
  { Nombre: 'Bilirrubina total', UnidaddeMedida: 'mg/dL', ValorReferencial: '0.1-1.2', ItemLaboratorioId: 7 },
  { Nombre: 'Bilirrubina directa', UnidaddeMedida: 'mg/dL', ValorReferencial: '0.0-0.3', ItemLaboratorioId: 7 },
  { Nombre: 'Alcalina fosfatasa', UnidaddeMedida: 'U/L', ValorReferencial: '40-129', ItemLaboratorioId: 7 },
  { Nombre: 'Sodio', UnidaddeMedida: 'mmol/L', ValorReferencial: '135-145', ItemLaboratorioId: 8 },
  { Nombre: 'Potasio', UnidaddeMedida: 'mmol/L', ValorReferencial: '3.5-5.0', ItemLaboratorioId: 8 },
  { Nombre: 'Cloro', UnidaddeMedida: 'mmol/L', ValorReferencial: '98-107', ItemLaboratorioId: 8 },
  { Nombre: 'Calcio', UnidaddeMedida: 'mg/dL', ValorReferencial: '8.6-10.3', ItemLaboratorioId: 8 },
  { Nombre: 'Magnesio', UnidaddeMedida: 'mg/dL', ValorReferencial: '1.7-2.2', ItemLaboratorioId: 8 },
  // Uroanálisis
  { Nombre: 'Densidad', UnidaddeMedida: 'g/mL', ValorReferencial: '1.005-1.030', ItemLaboratorioId: 9 },
  { Nombre: 'pH', UnidaddeMedida: '', ValorReferencial: '4.6-8.0', ItemLaboratorioId: 9 },
  { Nombre: 'Glucosa', UnidaddeMedida: 'mg/dL', ValorReferencial: 'Negativo', ItemLaboratorioId: 9 },
  { Nombre: 'Proteínas', UnidaddeMedida: 'mg/dL', ValorReferencial: 'Negativo', ItemLaboratorioId: 9 },
  { Nombre: 'Células epiteliales', UnidaddeMedida: 'células/HPF', ValorReferencial: '0-5', ItemLaboratorioId: 9 },
  { Nombre: 'Cultivo de bacteria', UnidaddeMedida: '', ValorReferencial: 'Presencia/Ausencia', ItemLaboratorioId: 10 },
  { Nombre: 'Sensibilidad a antibióticos', UnidaddeMedida: '', ValorReferencial: 'Resistente/Susceptible', ItemLaboratorioId: 10 },
  { Nombre: 'Cultivo de microorganismos', UnidaddeMedida: '', ValorReferencial: 'Presencia/Ausencia', ItemLaboratorioId: 11 },
  { Nombre: 'Identificación de parásitos', UnidaddeMedida: '', ValorReferencial: 'Presencia/Ausencia', ItemLaboratorioId: 11 },
  { Nombre: 'Sedimento de orina', UnidaddeMedida: '', ValorReferencial: 'Normales/Anormales', ItemLaboratorioId: 12 },
  { Nombre: 'Cristales', UnidaddeMedida: '', ValorReferencial: 'Presencia/Ausencia', ItemLaboratorioId: 12 },
  { Nombre: 'Leucocitos', UnidaddeMedida: 'células/HPF', ValorReferencial: '0-5', ItemLaboratorioId: 12 },
  // Inmunología
  { Nombre: 'Anticuerpos IgG', UnidaddeMedida: '', ValorReferencial: 'Negativo/Positivo', ItemLaboratorioId: 13 },
  { Nombre: 'Anticuerpos IgM', UnidaddeMedida: '', ValorReferencial: 'Negativo/Positivo', ItemLaboratorioId: 13 },
  { Nombre: 'Anticuerpos anti-HIV', UnidaddeMedida: '', ValorReferencial: 'Negativo/Positivo', ItemLaboratorioId: 14 },
  { Nombre: 'Factor Reumatoide', UnidaddeMedida: 'UI/mL', ValorReferencial: '<14', ItemLaboratorioId: 15 },
  { Nombre: 'Pruebas de alergias', UnidaddeMedida: '', ValorReferencial: 'Positivo/Negativo', ItemLaboratorioId: 16 },
  { Nombre: 'Niveles de IgE', UnidaddeMedida: 'UI/mL', ValorReferencial: '0-100', ItemLaboratorioId: 16 },
  { Nombre: 'Anticuerpos anticardiolipina', UnidaddeMedida: 'UI/mL', ValorReferencial: '<15', ItemLaboratorioId: 16 },
  { Nombre: 'Anticuerpos anti-beta2-glicoproteína I', UnidaddeMedida: 'UI/mL', ValorReferencial: '<20', ItemLaboratorioId: 16 }
];
// tipos documento
tiposdocumentoPDF = [
  {
    Nombre: 'Titulo'
  },
  {
    Nombre: 'Bachiller'
  },
  {
    Nombre: 'Certificado'
  },
  {
    Nombre: 'Constancia'
  },
  {
    Nombre: 'Maestría'
  },
  {
    Nombre: 'Doctorado'
  },
  {
    Nombre: 'Especialización'
  },
  {
    Nombre: 'Colegiatura'
  },
  {
    Nombre: 'Ponencia'
  },
  {
    Nombre: 'Practica'
  },
  {
    Nombre: 'Experiencia'
  },
  {
    Nombre: 'Otros'
  }
];
// categorias y subcategorias de patrimonio
// categorias
categoriaspatrimonio = [
  {
    Nombre: 'Equipos Odontológicos',
    Descripcion: 'Equipamiento principal utilizado en procedimientos dentales y diagnósticos'
  },
  {
    Nombre: 'Instrumental Clínico',
    Descripcion: 'Herramientas e instrumentos específicos para procedimientos dentales'
  },
  {
    Nombre: 'Mobiliario Clínico y Administrativo',
    Descripcion: 'Muebles y elementos para áreas clínicas y administrativas'
  },
  {
    Nombre: 'Equipos de Laboratorio Dental',
    Descripcion: 'Equipamiento específico para trabajos de laboratorio dental'
  },
  {
    Nombre: 'Equipos de Informática y Tecnología',
    Descripcion: 'Equipos y sistemas tecnológicos para gestión y diagnóstico'
  },
  {
    Nombre: 'Equipos de Protección y Bioseguridad',
    Descripcion: 'Elementos y equipos para garantizar la seguridad biológica'
  },
  {
    Nombre: 'Vehículos y Transporte',
    Descripcion: 'Medios de transporte para servicios móviles y logística'
  },
  {
    Nombre: 'Otros Activos Fijos',
    Descripcion: 'Equipos y elementos complementarios para el funcionamiento del centro'
  }
];
// subcategorias
subcategoriaspatrimonio = [
  // Subcategorías de Equipos Odontológicos (id: 1)
  {
    Nombre: 'Unidades dentales',
    Descripcion: 'Sillones odontológicos completos con sistemas integrados',
    CategoriaPatrimonioId: 1
  },
  {
    Nombre: 'Compresores de aire',
    Descripcion: 'Equipos para suministro de aire comprimido a unidades dentales',
    CategoriaPatrimonioId: 1
  },
  {
    Nombre: 'Autoclaves y esterilizadores',
    Descripcion: 'Equipos para esterilización de instrumental',
    CategoriaPatrimonioId: 1
  },
  {
    Nombre: 'Equipos de rayos X',
    Descripcion: 'Sistemas de radiografía intraoral y panorámica',
    CategoriaPatrimonioId: 1
  },
  {
    Nombre: 'Lámparas de fotocurado',
    Descripcion: 'Dispositivos para polimerización de materiales dentales',
    CategoriaPatrimonioId: 1
  },
  // Subcategorías de Instrumental Clínico (id: 2)
  {
    Nombre: 'Instrumental básico',
    Descripcion: 'Espejos, pinzas, exploradores y otros instrumentos básicos',
    CategoriaPatrimonioId: 2
  },
  {
    Nombre: 'Instrumental de cirugía',
    Descripcion: 'Instrumentos específicos para procedimientos quirúrgicos',
    CategoriaPatrimonioId: 2
  },
  {
    Nombre: 'Instrumental de endodoncia',
    Descripcion: 'Instrumentos para tratamientos de conductos',
    CategoriaPatrimonioId: 2
  },
  {
    Nombre: 'Instrumental de periodoncia',
    Descripcion: 'Instrumentos para tratamientos periodontales',
    CategoriaPatrimonioId: 2
  },
  // Subcategorías de Mobiliario Clínico y Administrativo (id: 3)
  {
    Nombre: 'Muebles de consultorio',
    Descripcion: 'Escritorios, sillas y mesas para área clínica',
    CategoriaPatrimonioId: 3
  },
  {
    Nombre: 'Mobiliario sala de espera',
    Descripcion: 'Sillas, sofás y mesas para área de espera',
    CategoriaPatrimonioId: 3
  },
  {
    Nombre: 'Archivadores',
    Descripcion: 'Muebles para almacenamiento de documentos y fichas',
    CategoriaPatrimonioId: 3
  },
  // Subcategorías de Equipos de Laboratorio Dental (id: 4)
  {
    Nombre: 'Hornos de cerámica',
    Descripcion: 'Equipos para procesamiento de materiales cerámicos',
    CategoriaPatrimonioId: 4
  },
  {
    Nombre: 'Recortadoras de modelos',
    Descripcion: 'Equipos para recorte y ajuste de modelos dentales',
    CategoriaPatrimonioId: 4
  },
  {
    Nombre: 'Pulidoras',
    Descripcion: 'Equipos para pulido de prótesis y trabajos dentales',
    CategoriaPatrimonioId: 4
  },
  // Subcategorías de Equipos de Informática y Tecnología (id: 5)
  {
    Nombre: 'Computadoras y laptops',
    Descripcion: 'Equipos informáticos para gestión y registro',
    CategoriaPatrimonioId: 5
  },
  {
    Nombre: 'Software odontológico',
    Descripcion: 'Programas y licencias para gestión dental',
    CategoriaPatrimonioId: 5
  },
  {
    Nombre: 'Cámaras intraorales',
    Descripcion: 'Dispositivos para fotografía dental intraoral',
    CategoriaPatrimonioId: 5
  },
  // Subcategorías de Equipos de Protección y Bioseguridad (id: 6)
  {
    Nombre: 'Purificadores de aire',
    Descripcion: 'Sistemas de filtración y purificación de aire',
    CategoriaPatrimonioId: 6
  },
  {
    Nombre: 'Equipos de esterilización UV',
    Descripcion: 'Sistemas de desinfección por luz ultravioleta',
    CategoriaPatrimonioId: 6
  },
  // Subcategorías de Vehículos y Transporte (id: 7)
  {
    Nombre: 'Vehículos clínicos',
    Descripcion: 'Vehículos adaptados para servicios odontológicos móviles',
    CategoriaPatrimonioId: 7
  },
  {
    Nombre: 'Vehículos de mensajería',
    Descripcion: 'Vehículos para servicios de mensajería y logística',
    CategoriaPatrimonioId: 7
  },
  // Subcategorías de Otros Activos Fijos (id: 8)
  {
    Nombre: 'Sistemas de emergencia',
    Descripcion: 'Generadores eléctricos y sistemas de respaldo',
    CategoriaPatrimonioId: 8
  },
  {
    Nombre: 'Sistemas de climatización',
    Descripcion: 'Aires acondicionados y control de temperatura',
    CategoriaPatrimonioId: 8
  }
];
// categorias y subcategorias de inventario
// categoria
categoriasinvetario = [
  {
    Nombre: 'Materiales de Restauración',
    Descripcion: 'Materiales utilizados para restauraciones dentales directas e indirectas'
  },
  {
    Nombre: 'Materiales de Endodoncia',
    Descripcion: 'Insumos específicos para tratamientos de conductos radiculares'
  },
  {
    Nombre: 'Materiales de Impresión',
    Descripcion: 'Materiales para toma de impresiones y modelos dentales'
  },
  {
    Nombre: 'Materiales Quirúrgicos',
    Descripcion: 'Insumos para procedimientos quirúrgicos orales'
  },
  {
    Nombre: 'Materiales de Profilaxis',
    Descripcion: 'Productos para limpieza y prevención dental'
  },
  {
    Nombre: 'Descartables y Bioseguridad',
    Descripcion: 'Elementos de protección y seguridad biológica'
  },
  {
    Nombre: 'Instrumental Rotatorio',
    Descripcion: 'Elementos de corte y pulido para piezas de mano'
  },
  {
    Nombre: 'Productos Farmacéuticos',
    Descripcion: 'Medicamentos y productos farmacéuticos de uso odontológico'
  },
  {
    Nombre: 'Equipos y Accesorios',
    Descripcion: 'Instrumentos y accesorios complementarios para procedimientos'
  },
  {
    Nombre: 'Material de Oficina',
    Descripcion: 'Insumos administrativos y de gestión'
  }
];
// subcategorias
subcategoriasinventario = [
  // Subcategorías de Materiales de Restauración (id: 1)
  {
    Nombre: 'Resinas compuestas',
    Descripcion: 'Resinas fotocurables para restauraciones directas (bulk-fill, fluidas, universales)',
    CategoriaInventarioId: 1
  },
  {
    Nombre: 'Ionómeros de vidrio',
    Descripcion: 'Materiales de restauración bioactivos convencionales y modificados con resina',
    CategoriaInventarioId: 1
  },
  {
    Nombre: 'Adhesivos dentales',
    Descripcion: 'Sistemas adhesivos de grabado total y autograbantes',
    CategoriaInventarioId: 1
  },
  {
    Nombre: 'Cementos dentales',
    Descripcion: 'Cementos provisionales y definitivos para restauraciones',
    CategoriaInventarioId: 1
  },
  // Subcategorías de Materiales de Endodoncia (id: 2)
  {
    Nombre: 'Limas endodónticas',
    Descripcion: 'Instrumentos manuales y rotatorios para tratamiento de conductos',
    CategoriaInventarioId: 2
  },
  {
    Nombre: 'Materiales de obturación',
    Descripcion: 'Conos de gutapercha y selladores endodónticos',
    CategoriaInventarioId: 2
  },
  {
    Nombre: 'Irrigantes',
    Descripcion: 'Soluciones para irrigación y desinfección de conductos',
    CategoriaInventarioId: 2
  },
  // Subcategorías de Materiales de Impresión (id: 3)
  {
    Nombre: 'Materiales elásticos',
    Descripcion: 'Siliconas, alginatos y poliéteres para impresión',
    CategoriaInventarioId: 3
  },
  {
    Nombre: 'Yesos dentales',
    Descripcion: 'Diferentes tipos de yesos para modelos de estudio y trabajo',
    CategoriaInventarioId: 3
  },
  {
    Nombre: 'Cubetas',
    Descripcion: 'Cubetas estándar y personalizadas para impresión',
    CategoriaInventarioId: 3
  },
  // Subcategorías de Materiales Quirúrgicos (id: 4)
  {
    Nombre: 'Material de sutura',
    Descripcion: 'Hilos de sutura reabsorbibles y no reabsorbibles',
    CategoriaInventarioId: 4
  },
  {
    Nombre: 'Materiales hemostáticos',
    Descripcion: 'Productos para control de sangrado',
    CategoriaInventarioId: 4
  },
  {
    Nombre: 'Anestésicos',
    Descripcion: 'Cartuchos de anestesia y agujas dentales',
    CategoriaInventarioId: 4
  },
  // Subcategorías de Materiales de Profilaxis (id: 5)
  {
    Nombre: 'Pastas profilácticas',
    Descripcion: 'Pastas para limpieza y pulido dental',
    CategoriaInventarioId: 5
  },
  {
    Nombre: 'Fluoruros',
    Descripcion: 'Geles y barnices de flúor',
    CategoriaInventarioId: 5
  },
  {
    Nombre: 'Selladores',
    Descripcion: 'Selladores de fosas y fisuras',
    CategoriaInventarioId: 5
  },
  // Subcategorías de Descartables y Bioseguridad (id: 6)
  {
    Nombre: 'Elementos de protección personal',
    Descripcion: 'Guantes, barbijos, gorros y protección ocular',
    CategoriaInventarioId: 6
  },
  {
    Nombre: 'Material de desinfección',
    Descripcion: 'Desinfectantes y esterilizantes',
    CategoriaInventarioId: 6
  },
  {
    Nombre: 'Barreras de protección',
    Descripcion: 'Films y cobertores para equipos',
    CategoriaInventarioId: 6
  },
  // Subcategorías de Instrumental Rotatorio (id: 7)
  {
    Nombre: 'Fresas',
    Descripcion: 'Fresas de carburo y diamante para alta y baja velocidad',
    CategoriaInventarioId: 7
  },
  {
    Nombre: 'Elementos de pulido',
    Descripcion: 'Discos, gomas y puntas de pulido',
    CategoriaInventarioId: 7
  },
  // Subcategorías de Productos Farmacéuticos (id: 8)
  {
    Nombre: 'Medicamentos orales',
    Descripcion: 'Analgésicos, antibióticos y antiinflamatorios',
    CategoriaInventarioId: 8
  },
  {
    Nombre: 'Medicamentos tópicos',
    Descripcion: 'Antisépticos y medicamentos de uso local',
    CategoriaInventarioId: 8
  },
  // Subcategorías de Equipos y Accesorios (id: 9)
  {
    Nombre: 'Matrices y bandas',
    Descripcion: 'Sistemas de matrices y bandas para restauraciones',
    CategoriaInventarioId: 9
  },
  {
    Nombre: 'Accesorios varios',
    Descripcion: 'Cuñas, porta matrices, clamps',
    CategoriaInventarioId: 9
  },
  // Subcategorías de Material de Oficina (id: 10)
  {
    Nombre: 'Papelería',
    Descripcion: 'Material de escritorio y documentación',
    CategoriaInventarioId: 10
  },
  {
    Nombre: 'Insumos informáticos',
    Descripcion: 'Cartuchos de impresora, CDs, USBs',
    CategoriaInventarioId: 10
  }
];
almacenes = [
  {
    Nombre: 'Almacén Principal',
    Ubicacion: 'Piso 1, Sector B - Almacén Central',
    ResponsableId: 1,
    ResponsableAlmacen: 'Anibal Jhamil Huaman Verastein',
    SedeId: 1
  },
  {
    Nombre: 'Consultorio Odontológico 1',
    Ubicacion: 'Piso 2, Consultorio 1',
    ResponsableId: 2,
    ResponsableAlmacen: 'Rodrigo Salazar Lazo',
    SedeId: 1
  }
];
// Datos fijos a insertar
// datos de los hallazgos
const hallazgos = [
  {
    Nombre: 'APARATO ORTODÓNTICO FIJO',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'APARATO ORTODÓNTICO REMOVIBLE',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'CORONA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'CORONA TEMPORAL',
    Tipo: 'Individual'
  },
  {
    Nombre: 'DEFECTOS DE DESARROLLO DEL ESMALTE (DDE)',
    Tipo: 'Individual'
  },
  {
    Nombre: 'DIASTEMA',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'EDÉNTULO TOTAL SUPERIOR / INFERIOR ',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'ESPIGO – MUÑÓN',
    Tipo: 'Individual'
  },
  {
    Nombre: 'FOSAS Y FISURAS PROFUNDAS',
    Tipo: 'Individual'
  },
  {
    Nombre: 'FRACTURA DENTAL',
    Tipo: 'Individual'
  },
  {
    Nombre: 'FUSIÓN',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'GEMINACIÓN',
    Tipo: 'Individual'
  },
  {
    Nombre: 'GIROVERSIÓN',
    Tipo: 'Individual'
  },
  {
    Nombre: 'IMPACTACIÓN',
    Tipo: 'Individual'
  },
  {
    Nombre: 'IMPLANTE DENTAL',
    Tipo: 'Individual'
  },
  {
    Nombre: 'LESIÓN DE CARIES DENTAL',
    Tipo: 'Individual'
  },
  {
    Nombre: 'MACRODONCIA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'MICRODONCIA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'MOVILIDAD PATOLÓGICA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA AUSENTE',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA EN CLAVIJA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA ECTÓPICA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA EN ERUPCIÓN',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA EXTRUIDA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA INTRUIDA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PIEZA DENTARIA SUPERNUMERARIA',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'PULPOTOMÍA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'POSICIÓN ANORMAL DENTARIA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'PRÓTESIS DENTAL PARCIAL FIJA',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'PRÓTESIS DENTAL COMPLETA SUPERIOR / INFERIOR',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'PRÓTESIS DENTAL PARCIAL REMOVIBLE',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'REMANENTE RADICULAR',
    Tipo: 'Individual'
  },
  {
    Nombre: 'RESTAURACIÓN DEFINITIVA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'RESTAURACIÓN TEMPORAL',
    Tipo: 'Individual'
  },
  {
    Nombre: 'SELLANTES',
    Tipo: 'Individual'
  },
  {
    Nombre: 'SUPERFICIE DESGASTADA',
    Tipo: 'Individual'
  },
  {
    Nombre: 'TRATAMIENTO DE CONDUCTO',
    Tipo: 'Individual'
  },
  {
    Nombre: 'TRANSPOSICIÓN DENTARIA',
    Tipo: 'Grupal'
  },
  {
    Nombre: 'FUERA DE LA NORMA TECNICA 188',
    Tipo: 'Ninguno'
  },
];
// datos de las categorias
const categorias = [
  { Nombre: 'GENERAL' },
  { Nombre: 'PREVENCIÓN' },
  { Nombre: 'RECUPERATIVA' },
  { Nombre: 'MANTENEDOR DE ESPACIO' },
  { Nombre: 'RESTAURACIÓN CON AMALGAMA' },
  { Nombre: 'RESTAURACIONES CON RESINA' },
  { Nombre: 'RESTAURACIONES CON IONOMERO' },
  { Nombre: 'ENDODONCIA' },
  { Nombre: 'PERIODONCIA' },
  { Nombre: 'PERIODONCIA SIN CIRUGÍA' },
  { Nombre: 'INCRUSTACIONES INLAY - ONLAY' },
  { Nombre: 'PROTESIS FIJA' },
  { Nombre: 'OTROS SERVICIOS DE PROTESIS FIJA' },
  { Nombre: 'APICOFORMACIÓN / RECALCIFICACIÓN' },
  { Nombre: 'APICECTOMÍA' },
  { Nombre: 'OTROS PROCEDIMIENTOS ENDODÓNTICOS' },
  { Nombre: 'PROCEIMIENTOS DE PERIODONCIA SIN CIRUGÍAD' },
  { Nombre: 'PROSTODONCIA REMOVIBLE' },
  { Nombre: 'AJUSTES DE PRÓTESIS' },
  { Nombre: 'REPARACIÓN DE DENTADURAS COMPLETAS' },
  { Nombre: 'REPARACIÓN DE DENTADURAS DE ACRÍLICO' },
  { Nombre: 'PROCEDIMIENTOS DE REBASE DE DENTADURA (CAMBIO DE TODA LA BASE DE ACRÍLICO) ' },
  { Nombre: 'PROCEDIMIENTO DE REVESTIMIENTO DE DENTADURA (PARA PRÓTESIS MAL ADAPTADA)' },
  { Nombre: 'PRÓTESIS PROVISIONALES' },
  { Nombre: 'OTROS SERVICIOS PARA PRÓTESIS REMOVIBLE' },
  { Nombre: 'PRÓTESIS MÁXILO FACIAL' },
  { Nombre: 'IMPLANTES' },
  { Nombre: 'PROSTODONCIA FIJA - PONTICOS' },
  { Nombre: 'CIRUGÍA MAXILOFACIAL' },
  { Nombre: 'Procedimiento X' },
  { Nombre: 'ORTODONCIA' },
  { Nombre: 'OTROS PROCEDIMIENTOS' },
  { Nombre: 'PROCEDIMIENTOS ESPECIALES' }
];
// datos de los catalogos
const catalogos = [
  { HallazgoId: 39, Modo: 'Ninguno', Nombre: 'Consulta'},  // 1
  { HallazgoId: 34, Modo: 'Individual', Nombre: 'Restauracion Temporal'}, // 2
  { HallazgoId: 33, Modo: 'Individual', Nombre: 'Restauracion Definitiva'}, // 3
  { HallazgoId: 35, Modo: 'Individual', Nombre: 'Sellante'}, //4
  { HallazgoId: 37, Modo: 'Individual', Nombre: 'Endodoncia'}, // 5
  { HallazgoId: 37, Modo: 'Individual', Nombre: 'Pulpectomía'}, // 6
  { HallazgoId: 27, Modo: 'Individual', Nombre: 'Pulpotomia'}, // 7
  { HallazgoId: 15, Modo: 'Individual', Nombre: 'Implante Dental'}, // 8
  { HallazgoId: 1, Modo: 'Grupal', Nombre: 'Ortodoncia Fija'}, // 9
  { HallazgoId: 2, Modo: 'Grupal', Nombre: 'Ortodoncia Removible'},  // 10
  { HallazgoId: 3, Modo: 'Individual', Nombre: 'Corona Fija'}, // 11
  { HallazgoId: 4, Modo: 'Individual', Nombre: 'Corona Temporal'}, // 12
  { HallazgoId: 29, Modo: 'Grupal', Nombre: 'Protesis Parcial Fija'}, // 13
  { HallazgoId: 31, Modo: 'Grupal', Nombre: 'Protesis Parcial Removible'}, // 14
  { HallazgoId: 30, Modo: 'Grupal', Nombre: 'Protesis Completa Maxilar'}, // 15
  { HallazgoId: 30, Modo: 'Grupal', Nombre: 'Protesis Completa Mandibular'}, // 16
  { HallazgoId: 39, Modo: 'Ninguno', Nombre: 'Radiografia'}, // 17
  { HallazgoId: 39, Modo: 'Ninguno', Nombre: 'Prevencion'} // 18
];

const tarifarios = [
  { Categoria: 'Consulta', Afecta: 'No', Nombre: 'Examen Clinico y Odontograma', 
    Modo: 'Ninguno', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Rimac Seguros y Reaseguros', 
    RUCIAFA: '20100041953', IAFAId: 1, CatalogoId: 1 },
  { Categoria: 'Consulta', Afecta: 'No', Nombre: 'Consulta', 
    Modo: 'Ninguno', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Mapfre Peru Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20418896915', IAFAId: 2, CatalogoId: 1 },
  // solo tenemos el tarifario de pacifico seguros
  // la consulta
  { Categoria: 'Consulta', Afecta: 'No', Nombre: 'Consulta', 
    Modo: 'Ninguno', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 1 },
  // cirugia bucal
  { Categoria: 'Cirugia Bucal', Afecta: 'Si', Nombre: 'Exodoncia Simple', 
    Modo: 'Individual', PrecioMinimo: '30', Precio: '30', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  // restauraciones directas
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion con Amalgama Simple', 
    Modo: 'Individual', PrecioMinimo: '23', Precio: '23', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion con Amalgama Compuesta', 
    Modo: 'Individual', PrecioMinimo: '37', Precio: '37', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion con Amalgama Completa', 
    Modo: 'Individual', PrecioMinimo: '61', Precio: '61', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion Anterior con Resina Simple', 
    Modo: 'Individual', PrecioMinimo: '40', Precio: '40', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion Anterior con Resina Compuesta', 
    Modo: 'Individual', PrecioMinimo: '60', Precio: '60', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion Anterior con Resina Completa', 
    Modo: 'Individual', PrecioMinimo: '80', Precio: '80', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion Posterior con Resina Simple', 
    Modo: 'Individual', PrecioMinimo: '40', Precio: '40', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion Posterior con Resina Compuesta', 
    Modo: 'Individual', PrecioMinimo: '60', Precio: '60', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  { Categoria: 'Restauraciones Directas', Afecta: 'Si', Nombre: 'Obturacion Posterior con Resina Completa', 
    Modo: 'Individual', PrecioMinimo: '80', Precio: '80', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 3 },
  // prevenciones
  { Categoria: 'Prevencion', Afecta: 'No', Nombre: 'Consulta Preventiva Odontologica', 
    Modo: 'Individual', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 18 },
  { Categoria: 'Prevencion', Afecta: 'No', Nombre: 'Profilaxis Simple', 
    Modo: 'Individual', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 18 },
  { Categoria: 'Prevencion', Afecta: 'No', Nombre: 'Destartaje', 
    Modo: 'Individual', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 18 },
  { Categoria: 'Prevencion', Afecta: 'No', Nombre: 'Aplicación de Fluor', 
    Modo: 'Individual', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 18 },
  { Categoria: 'Prevencion', Afecta: 'No', Nombre: 'Sellante por pieza', 
    Modo: 'Individual', PrecioMinimo: '15', Precio: '15', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 4 },
    // radiografia y rayos x
  { Categoria: 'Rayos X', Afecta: 'No', Nombre: 'Rayos X Bite Wing', 
    Modo: 'Ninguno', PrecioMinimo: '30', Precio: '30', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 17 },
  { Categoria: 'Rayos X', Afecta: 'No', Nombre: 'Rayos X Periapical', 
    Modo: 'Ninguno', PrecioMinimo: '30', Precio: '30', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 17 },
  { Categoria: 'Rayos X', Afecta: 'No', Nombre: 'Rayos X Oclusal', 
    Modo: 'Ninguno', PrecioMinimo: '30', Precio: '30', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 17 },
  { Categoria: 'Rayos X', Afecta: 'No', Nombre: 'Radiografia Panorámica', 
    Modo: 'Ninguno', PrecioMinimo: '30', Precio: '30', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 17 },
  // endodoncias
  { Categoria: 'Endodoncia', Afecta: 'Si', Nombre: 'Pulpotomia', 
    Modo: 'Individual', PrecioMinimo: '60', Precio: '60', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 5 },
  { Categoria: 'Endodoncia', Afecta: 'Si', Nombre: 'Pulpectomía', 
    Modo: 'Individual', PrecioMinimo: '75', Precio: '75', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 6 },
  { Categoria: 'Endodoncia', Afecta: 'Si', Nombre: 'Endodoncia Anterior (incisivos y caninos)', 
    Modo: 'Individual', PrecioMinimo: '100', Precio: '100', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 5 },
  { Categoria: 'Endodoncia', Afecta: 'Si', Nombre: 'Endodoncia Posterior (premolar)', 
    Modo: 'Individual', PrecioMinimo: '120', Precio: '120', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 5 },
  { Categoria: 'Endodoncia', Afecta: 'Si', Nombre: 'Endodoncia Posterior (molar)', 
    Modo: 'Individual', PrecioMinimo: '150', Precio: '150', 
    NombreIAFA: 'Pacifico Compañia de Seguros y Reaseguros', 
    RUCIAFA: '20332970411', IAFAId: 3, CatalogoId: 5 },
  { Categoria: 'Consulta', Afecta: 'No', Nombre: 'Consulta', 
    Modo: 'Ninguno', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'SANITAS PERU S.A. - EPS', 
    RUCIAFA: '20523470761', IAFAId: 4, CatalogoId: 1 },
  { Categoria: 'Consulta', Afecta: 'No', Nombre: 'Consulta', 
    Modo: 'Ninguno', PrecioMinimo: '0', Precio: '0', 
    NombreIAFA: 'Sigma Dental', 
    RUCIAFA: '20519133530', IAFAId: 5, CatalogoId: 1 },
  { Categoria: 'Consulta', Afecta: 'No', Nombre: 'Consulta', 
    Modo: 'Ninguno', PrecioMinimo: '40', Precio: '60', 
    NombreIAFA: 'Particular', RUCIAFA: '00000000000', IAFAId: 6, CatalogoId: 1 }
];

const procedimientos = [
  { Categoria: 1, Codigo: 'D0120', Nombre: 'Examen estomatológico'},
  { Categoria: 1, Codigo: 'D0160', Nombre: 'Consulta estomatológica especializada especializada'},
  { Categoria: 1, Codigo: 'D0140', Nombre: 'Consulta estomatológica no especializada'},
  { Categoria: 1, Codigo: 'D0220', Nombre: 'Radiografía intraoral periapical'},
  { Categoria: 1, Codigo: 'D0240', Nombre: 'Radiografía intraoral oclusal'},
  { Categoria: 1, Codigo: 'D0250', Nombre: 'Radiografía extraoral'},
  { Categoria: 1, Codigo: 'D0270', Nombre: 'Radiografía bitewing'},
  { Categoria: 1, Codigo: 'D0290', Nombre: 'Radiografía postero - anterior o lateral de cráneo y huesos faciales'},
  { Categoria: 1, Codigo: 'D0310', Nombre: 'Sialografía'},
  { Categoria: 1, Codigo: 'D0322', Nombre: 'Estudio tomográfico'},
  { Categoria: 1, Codigo: 'D0330', Nombre: 'Radiografía panorámica'},
  { Categoria: 1, Codigo: 'D0340', Nombre: 'Radiografía cefalométrica'},
  { Categoria: 1, Codigo: 'D0321', Nombre: 'Otras radiografías de la articulación temporomandibular con informe'},
  { Categoria: 1, Codigo: 'D0350', Nombre: 'Imágenes fotográfica oral y facial'},
  { Categoria: 1, Codigo: 'D0415', Nombre: 'Recolección de muestra de microorganismo para cultivo y prueba de sensibilidad'},
  { Categoria: 1, Codigo: 'D0416', Nombre: 'Cultivo viral'},
  { Categoria: 1, Codigo: 'D0425', Nombre: 'Pruebas de susceptibilidad de la caries'},
  { Categoria: 1, Codigo: 'D0460', Nombre: 'Pruebas de vitalidad de la pulpa'},
  { Categoria: 1, Codigo: 'D0470', Nombre: 'Impresiones dentales para diagnostico'}
];

// datos de los usuarios
const usuarios = [{
    // usuario ingeinero
    Nombre: 'Anibal Jhamil',
    Apellido: 'Huaman Verastein',
    Correo: 'anibaljhamil@gmail.com',
    Celular: '958899251',
    TipoDocumentoId: 1,
    Documento: '72547410',
    Colegiatura: '3253251',
    CodigoEspecialista: '235qwteg',
    FechaNacimiento: '1997-04-11',
    GeneroId: 1,
    Codigo: 'adfasf',
    Contrasenia: 'wasaaa',
    TipoUsuarioId: 2,
    EstadoId: 1,
    VinculacionId: 8,
    SedeId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
  },
  {
    // usuario odontologo y a la vez es el duenio
    Nombre: 'Rodrigo',
    Apellido: 'Salazar Lazo',
    Correo: 'rsalazar68@gmail.com',
    Celular: '964630193',
    TipoDocumentoId: 1,
    Documento: '20056897',
    Colegiatura: '6862',
    CodigoEspecialista: '5435643g',
    FechaNacimiento: '1968-09-04',
    GeneroId: 1,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 6,
    EstadoId: 1,
    VinculacionId: 2,
    SedeId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
  },
  {
    // usuario administrador global
    Nombre: 'Administrador',
    Apellido: 'Global',
    Correo: 'jxdesignui@gmail.com',
    Celular: '938811980',
    TipoDocumentoId: 1,
    Documento: '72547411',
    Colegiatura: '',
    CodigoEspecialista: '',
    FechaNacimiento: '1997-04-11',
    GeneroId: 1,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 1,
    EstadoId: 1,
    VinculacionId: 2,
    SedeId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
  },
  {
    // usuario administrador sede
    Nombre: 'Luis',
    Apellido: 'Fernández',
    Correo: 'luis.fernández@gmail.com',
    Celular: '911111111',
    TipoDocumentoId: 1,
    Documento: '48329787',
    Colegiatura: 'COL2266',
    CodigoEspecialista: '54twrehs',
    FechaNacimiento: '1979-05-21',
    GeneroId: 1,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 3,
    EstadoId: 1,
    VinculacionId: 2,
    SedeId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
  },
  { // usuario recepcionista
    Nombre: 'Yoseannie de Jesus',
    Apellido: 'Ordoñez Losada',
    Correo: 'pilar.gomez@gmail.com',
    Celular: '922222222',
    TipoDocumentoId: 2,
    Documento: '0012028534',
    Colegiatura: 'no hay',
    CodigoEspecialista: 'no hay',
    FechaNacimiento: '1995-11-27',
    GeneroId: 2,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 4,
    EstadoId: 1,
    VinculacionId: 1,
    SedeId: 1,
    Foto: ''
  },
  {
    // usuario asistente
    Nombre: 'Elena',
    Apellido: 'Díaz',
    Correo: 'elena.díaz@gmail.com',
    Celular: '933333333',
    TipoDocumentoId: 1,
    Documento: '46047909',
    Colegiatura: 'COL1002',
    CodigoEspecialista: 'fasdhdfshfd',
    FechaNacimiento: '1970-01-06',
    GeneroId: 2,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 5,
    EstadoId: 1,
    VinculacionId: 2,
    SedeId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
  },
  {
    // usuario odontologo
    Nombre: 'Victor',
    Apellido: 'Santillan García Blasquez',
    Correo: 'mardebar93@gmail.com',
    Celular: '964301144',
    TipoDocumentoId: 1,
    Documento: '20103945',
    Colegiatura: '20332',
    CodigoEspecialista: '1233',
    FechaNacimiento: '1977-04-08',
    GeneroId: 1,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 6,
    EstadoId: 1,
    VinculacionId: 1,
    SedeId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
  },
  {
    // usuario odontologo
    Nombre: 'Raul Antonio',
    Apellido: 'Quillatupa Gutarra',
    Correo: 'quillatupa93@gmail.com',
    Celular: '945526451',
    TipoDocumentoId: 1,
    Documento: '73080800',
    Colegiatura: '47428',
    CodigoEspecialista: 'no hay',
    FechaNacimiento: '1993-05-26',
    GeneroId: 1,
    Codigo: 'adfasf',
    Contrasenia: 'wasa',
    TipoUsuarioId: 6,
    EstadoId: 1,
    VinculacionId: 1,
    SedeId: 1,
    Foto: ''
  },
]
const pacientes = [{
    Nombres: 'Anibal Jhamil',
    Apellidos: 'Huaman Verastein',
    Correo: 'anibaljhamil@gmail.com',
    Celular: '958899251',
    TipoDocumentoId: 1,
    Documento: '72547410',
    NroHistoriaClinica: '72547410',
    FechaNacimiento: '1997-04-11',
    Ocupacion: 'FreeLancer - Ingeniero',
    Observacion: 'Ninguna',
    TipoAfiliacion: 'Titular',
    FechaAfiliacion: '2025-03-11',
    IAFAId: 3,
    GeneroId: 1,
    GradoInstruccionId: 10,
    SedeId: 1,
    FuenteCaptacionId: 1,
    OdontologoId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png',
    AntecedentesFamiliares: '',
    AntecedentesPersonales: '',
  },
  {
    Nombres: 'SIN',
    Apellidos: 'TURNO',
    Correo: 'jxdesignui@gmail.com',
    Celular: '938811980',
    TipoDocumentoId: 1,
    Documento: '00000000',
    NroHistoriaClinica: '00000000',
    FechaNacimiento: '1997-04-11',
    Ocupacion: 'FreeLancer - Ingeniero',
    Observacion: 'Ninguna',
    TipoAfiliacion: 'Titular',
    FechaAfiliacion: '2025-03-11',
    IAFAId: 6,
    GeneroId: 1,
    GradoInstruccionId: 10,
    SedeId: 1,
    FuenteCaptacionId: 1,
    OdontologoId: 1,
    Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png',
    AntecedentesFamiliares: '',
    AntecedentesPersonales: '',
  },
]
cuadrantes = [
  { Nombres: 'Cuadrante Superior Derecho' },
  { Nombres: 'Cuadrante Superior Izquierdo' },
  { Nombres: 'Cuadrante Inferior Derecho' },
  { Nombres: 'Cuadrante Inferior Izquierdo' },
  { Nombres: 'Cuadrante Superior Derecho Temporal' },
  { Nombres: 'Cuadrante Superior Izquierdo Temporal' },
  { Nombres: 'Cuadrante Inferior Derecho Temporal' },
  { Nombres: 'Cuadrante Inferior Izquierdo Temporal' }
];
// datos de ubicaciones de diente
ubicaciones = [
  { Nombres: 'incisivo' },
  { Nombres: 'canino' },
  { Nombres: 'premolar' },
  { Nombres: 'molar' }
];
tipos = [
  { Nombre: 'Permanente' },
  { Nombre: 'De Leche' },
];
dientes = [
  // Cuadrante 1 - Superior Derecho
  {
    Nombre: 'Incisivo Central Superior Derecho',
    NumeroDental: 11,
    FondoDental: 'assets/img/dientes/caninoseincisivos/11.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 1
  },
  {
    Nombre: 'Incisivo Lateral Superior Derecho',
    NumeroDental: 12,
    FondoDental: 'assets/img/dientes/caninoseincisivos/12.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 1
  },
  {
    Nombre: 'Canino Superior Derecho',
    NumeroDental: 13,
    FondoDental: 'assets/img/dientes/caninoseincisivos/13.png',
    TipoDienteId: 1,
    UbicacionId: 2,
    CuadranteId: 1
  },
  {
    Nombre: 'Primer Premolar Superior Derecho',
    NumeroDental: 14,
    FondoDental: 'assets/img/dientes/premolares/14.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 1
  },
  {
    Nombre: 'Segundo Premolar Superior Derecho',
    NumeroDental: 15,
    FondoDental: 'assets/img/dientes/premolares/15.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 1
  },
  {
    Nombre: 'Primer Molar Superior Derecho',
    NumeroDental: 16,
    FondoDental: 'assets/img/dientes/molares/16.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 1
  },
  {
    Nombre: 'Segundo Molar Superior Derecho',
    NumeroDental: 17,
    FondoDental: 'assets/img/dientes/molares/17.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 1
  },
  {
    Nombre: 'Tercer Molar Superior Derecho',
    NumeroDental: 18,
    FondoDental: 'assets/img/dientes/molares/18.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 1
  },
  // Cuadrante 2 - Superior Izquierdo
  {
    Nombre: 'Incisivo Central Superior Izquierdo',
    NumeroDental: 21,
    FondoDental: 'assets/img/dientes/caninoseincisivos/21.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 2
  },
  {
    Nombre: 'Incisivo Lateral Superior Izquierdo',
    NumeroDental: 22,
    FondoDental: 'assets/img/dientes/caninoseincisivos/22.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 2
  },
  {
    Nombre: 'Canino Superior Izquierdo',
    NumeroDental: 23,
    FondoDental: 'assets/img/dientes/caninoseincisivos/23.png',
    TipoDienteId: 1,
    UbicacionId: 2,
    CuadranteId: 2
  },
  {
    Nombre: 'Primer Premolar Superior Izquierdo',
    NumeroDental: 24,
    FondoDental: 'assets/img/dientes/premolares/24.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 2
  },
  {
    Nombre: 'Segundo Premolar Superior Izquierdo',
    NumeroDental: 25,
    FondoDental: 'assets/img/dientes/premolares/25.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 2
  },
  {
    Nombre: 'Primer Molar Superior Izquierdo',
    NumeroDental: 26,
    FondoDental: 'assets/img/dientes/molares/26.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 2
  },
  {
    Nombre: 'Segundo Molar Superior Izquierdo',
    NumeroDental: 27,
    FondoDental: 'assets/img/dientes/molares/27.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 2
  },
  {
    Nombre: 'Tercer Molar Superior Izquierdo',
    NumeroDental: 28,
    FondoDental: 'assets/img/dientes/molares/28.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 2
  },
  // Cuadrante 3 - Inferior Izquierdo
  {
    Nombre: 'Incisivo Central Inferior Izquierdo',
    NumeroDental: 31,
    FondoDental: 'assets/img/dientes/caninoseincisivos/31.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 3
  },
  {
    Nombre: 'Incisivo Lateral Inferior Izquierdo',
    NumeroDental: 32,
    FondoDental: 'assets/img/dientes/caninoseincisivos/32.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 3
  },
  {
    Nombre: 'Canino Inferior Izquierdo',
    NumeroDental: 33,
    FondoDental: 'assets/img/dientes/caninoseincisivos/33.png',
    TipoDienteId: 1,
    UbicacionId: 2,
    CuadranteId: 3
  },
  {
    Nombre: 'Primer Premolar Inferior Izquierdo',
    NumeroDental: 34,
    FondoDental: 'assets/img/dientes/premolares/34.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 3
  },
  {
    Nombre: 'Segundo Premolar Inferior Izquierdo',
    NumeroDental: 35,
    FondoDental: 'assets/img/dientes/premolares/35.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 3
  },
  {
    Nombre: 'Primer Molar Inferior Izquierdo',
    NumeroDental: 36,
    FondoDental: 'assets/img/dientes/molares/36.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 3
  },
  {
    Nombre: 'Segundo Molar Inferior Izquierdo',
    NumeroDental: 37,
    FondoDental: 'assets/img/dientes/molares/37.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 3
  },
  {
    Nombre: 'Tercer Molar Inferior Izquierdo',
    NumeroDental: 38,
    FondoDental: 'assets/img/dientes/molares/38.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 3
  },
  // Cuadrante 4 - Inferior Derecho
  {
    Nombre: 'Incisivo Central Inferior Derecho',
    NumeroDental: 41,
    FondoDental: 'assets/img/dientes/caninoseincisivos/41.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 4
  },
  {
    Nombre: 'Incisivo Lateral Inferior Derecho',
    NumeroDental: 42,
    FondoDental: 'assets/img/dientes/caninoseincisivos/42.png',
    TipoDienteId: 1,
    UbicacionId: 1,
    CuadranteId: 4
  },
  {
    Nombre: 'Canino Inferior Derecho',
    NumeroDental: 43,
    FondoDental: 'assets/img/dientes/caninoseincisivos/43.png',
    TipoDienteId: 1,
    UbicacionId: 2,
    CuadranteId: 4
  },
  {
    Nombre: 'Primer Premolar Inferior Derecho',
    NumeroDental: 44,
    FondoDental: 'assets/img/dientes/premolares/44.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 4
  },
  {
    Nombre: 'Segundo Premolar Inferior Derecho',
    NumeroDental: 45,
    FondoDental: 'assets/img/dientes/premolares/45.png',
    TipoDienteId: 1,
    UbicacionId: 3,
    CuadranteId: 4
  },
  {
    Nombre: 'Primer Molar Inferior Derecho',
    NumeroDental: 46,
    FondoDental: 'assets/img/dientes/molares/46.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 4
  },
  {
    Nombre: 'Segundo Molar Inferior Derecho',
    NumeroDental: 47,
    FondoDental: 'assets/img/dientes/molares/47.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 4
  },
  {
    Nombre: 'Tercer Molar Inferior Derecho',
    NumeroDental: 48,
    FondoDental: 'assets/img/dientes/molares/48.png',
    TipoDienteId: 1,
    UbicacionId: 4,
    CuadranteId: 4
  },
  // los dientes de leche
  // DIENTES TEMPORALES (DE LECHE)
  // Cuadrante 5 - Superior Derecho Temporal
  {
    Nombre: 'Incisivo Central Superior Derecho Temporal',
    NumeroDental: 51,
    FondoDental: 'assets/img/dientes/caninoseincisivos/51.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 5
  },
  {
    Nombre: 'Incisivo Lateral Superior Derecho Temporal',
    NumeroDental: 52,
    FondoDental: 'assets/img/dientes/caninoseincisivos/52.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 5
  },
  {
    Nombre: 'Canino Superior Derecho Temporal',
    NumeroDental: 53,
    FondoDental: 'assets/img/dientes/caninoseincisivos/53.png',
    TipoDienteId: 2,
    UbicacionId: 2,
    CuadranteId: 5
  },
  {
    Nombre: 'Primer Molar Superior Derecho Temporal',
    NumeroDental: 54,
    FondoDental: 'assets/img/dientes/molares/54.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 5
  },
  {
    Nombre: 'Segundo Molar Superior Derecho Temporal',
    NumeroDental: 55,
    FondoDental: 'assets/img/dientes/molares/55.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 5
  },
  // Cuadrante 6 - Superior Izquierdo Temporal
  {
    Nombre: 'Incisivo Central Superior Izquierdo Temporal',
    NumeroDental: 61,
    FondoDental: 'assets/img/dientes/caninoseincisivos/61.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 6
  },
  {
    Nombre: 'Incisivo Lateral Superior Izquierdo Temporal',
    NumeroDental: 62,
    FondoDental: 'assets/img/dientes/caninoseincisivos/62.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 6
  },
  {
    Nombre: 'Canino Superior Izquierdo Temporal',
    NumeroDental: 63,
    FondoDental: 'assets/img/dientes/caninoseincisivos/63.png',
    TipoDienteId: 2,
    UbicacionId: 2,
    CuadranteId: 6
  },
  {
    Nombre: 'Primer Molar Superior Izquierdo Temporal',
    NumeroDental: 64,
    FondoDental: 'assets/img/dientes/molares/64.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 6
  },
  {
    Nombre: 'Segundo Molar Superior Izquierdo Temporal',
    NumeroDental: 65,
    FondoDental: 'assets/img/dientes/molares/65.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 6
  },
  // Cuadrante 7 - Inferior Izquierdo Temporal
  {
    Nombre: 'Incisivo Central Inferior Izquierdo Temporal',
    NumeroDental: 71,
    FondoDental: 'assets/img/dientes/caninoseincisivos/71.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 8
  },
  {
    Nombre: 'Incisivo Lateral Inferior Izquierdo Temporal',
    NumeroDental: 72,
    FondoDental: 'assets/img/dientes/caninoseincisivos/72.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 8
  },
  {
    Nombre: 'Canino Inferior Izquierdo Temporal',
    NumeroDental: 73,
    FondoDental: 'assets/img/dientes/caninoseincisivos/73.png',
    TipoDienteId: 2,
    UbicacionId: 2,
    CuadranteId: 8
  },
  {
    Nombre: 'Primer Molar Inferior Izquierdo Temporal',
    NumeroDental: 74,
    FondoDental: 'assets/img/dientes/molares/74.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 8
  },
  {
    Nombre: 'Segundo Molar Inferior Izquierdo Temporal',
    NumeroDental: 75,
    FondoDental: 'assets/img/dientes/molares/75.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 8
  },
  // Cuadrante 8 - Inferior Derecho Temporal
  {
    Nombre: 'Incisivo Central Inferior Derecho Temporal',
    NumeroDental: 81,
    FondoDental: 'assets/img/dientes/caninoseincisivos/81.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 7
  },
  {
    Nombre: 'Incisivo Lateral Inferior Derecho Temporal',
    NumeroDental: 82,
    FondoDental: 'assets/img/dientes/caninoseincisivos/82.png',
    TipoDienteId: 2,
    UbicacionId: 1,
    CuadranteId: 7
  },
  {
    Nombre: 'Canino Inferior Derecho Temporal',
    NumeroDental: 83,
    FondoDental: 'assets/img/dientes/caninoseincisivos/83.png',
    TipoDienteId: 2,
    UbicacionId: 2,
    CuadranteId: 7
  },
  {
    Nombre: 'Primer Molar Inferior Derecho Temporal',
    NumeroDental: 84,
    FondoDental: 'assets/img/dientes/molares/84.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 7
  },
  {
    Nombre: 'Segundo Molar Inferior Derecho Temporal',
    NumeroDental: 85,
    FondoDental: 'assets/img/dientes/molares/85.png',
    TipoDienteId: 2,
    UbicacionId: 4,
    CuadranteId: 7
  }
];
// datos de tipo de concentimiento
tiposdeoperacion = [
  { Nombre: 'Extracción de muela del juicio' },
  { Nombre: 'Implante dental' },
  { Nombre: 'Tratamiento de conducto' },
  { Nombre: 'Obturación (empaste)' },
  { Nombre: 'Raspado y alisado radicular' },
  { Nombre: 'Blanqueamiento dental' },
  { Nombre: 'Colocación de corona dental' },
  { Nombre: 'Gingivectomía' },
  { Nombre: 'Apicectomía' },
  { Nombre: 'Frenectomía' }
];
// datos sobre los estados del diente
estadosdeldiente = [
  // ausente
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 20,
    Imagen: 'assets/img/hallazgos/ausente/grande/superior/ausente.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 20,
    Imagen: 'assets/img/hallazgos/ausente/grande/inferior/ausente.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 20,
    Imagen: 'assets/img/hallazgos/ausente/pequenio/superior/ausente.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 20,
    Imagen: 'assets/img/hallazgos/ausente/pequenio/inferior/ausente.png',
  },
  // clavija
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 21,
    Imagen: 'assets/img/hallazgos/clavija/grande/superior/clavija.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 21,
    Imagen: 'assets/img/hallazgos/clavija/grande/inferior/clavija.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 21,
    Imagen: 'assets/img/hallazgos/clavija/pequenio/superior/clavija.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 21,
    Imagen: 'assets/img/hallazgos/clavija/pequenio/inferior/clavija.png',
  },
  // erupcion
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 23,
    Imagen: 'assets/img/hallazgos/erupcion/grande/superior/erupcion.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 23,
    Imagen: 'assets/img/hallazgos/erupcion/grande/inferior/erupcion.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 23,
    Imagen: 'assets/img/hallazgos/erupcion/pequenio/superior/erupcion.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 23,
    Imagen: 'assets/img/hallazgos/erupcion/pequenio/inferior/erupcion.png',
  },
  // extruida
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 24,
    Imagen: 'assets/img/hallazgos/extruida/grande/superior/extruida.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 24,
    Imagen: 'assets/img/hallazgos/extruida/grande/inferior/extruida.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 24,
    Imagen: 'assets/img/hallazgos/extruida/pequenio/superior/extruida.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 24,
    Imagen: 'assets/img/hallazgos/extruida/pequenio/inferior/extruida.png',
  },
  // intruida
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 25,
    Imagen: 'assets/img/hallazgos/intruida/grande/superior/intruida.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 25,
    Imagen: 'assets/img/hallazgos/intruida/grande/inferior/intruida.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 25,
    Imagen: 'assets/img/hallazgos/intruida/pequenio/superior/intruida.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 25,
    Imagen: 'assets/img/hallazgos/intruida/pequenio/inferior/intruida.png',
  },
  // corona temporal
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 4,
    Imagen: 'assets/img/hallazgos/coronatemporal/grande/superior/coronatemporal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 4,
    Imagen: 'assets/img/hallazgos/coronatemporal/grande/inferior/coronatemporal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 4,
    Imagen: 'assets/img/hallazgos/coronatemporal/pequenio/superior/coronatemporal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 4,
    Imagen: 'assets/img/hallazgos/coronatemporal/pequenio/inferior/coronatemporal.png',
  },
  // germinacion
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 12,
    Imagen: 'assets/img/hallazgos/germinacion/grande/superior/germinacion.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 12,
    Imagen: 'assets/img/hallazgos/germinacion/grande/inferior/germinacion.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 12,
    Imagen: 'assets/img/hallazgos/germinacion/pequenio/superior/germinacion.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 12,
    Imagen: 'assets/img/hallazgos/germinacion/pequenio/inferior/germinacion.png',
  },
  // giroversion
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 13,
    Imagen: 'assets/img/hallazgos/giroversion/grande/superior/giroversion.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 13,
    Imagen: 'assets/img/hallazgos/giroversion/grande/inferior/giroversion.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 13,
    Imagen: 'assets/img/hallazgos/giroversion/pequenio/superior/giroversion.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 13,
    Imagen: 'assets/img/hallazgos/giroversion/pequenio/inferior/giroversion.png',
  },
  // dos imagenes por filtro (final e inicio)
  // diastema
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/grande/superior/final.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/grande/superior/inicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/grande/inferior/final.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/grande/inferior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/pequenio/superior/final.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/pequenio/superior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/pequenio/inferior/final.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 6,
    Imagen: 'assets/img/hallazgos/diastema/pequenio/inferior/inicio.png',
  },
  // fusion
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/grande/superior/final.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/grande/superior/inicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/grande/inferior/final.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/grande/inferior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/pequenio/superior/final.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/pequenio/superior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/pequenio/inferior/final.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 11,
    Imagen: 'assets/img/hallazgos/fusion/pequenio/inferior/inicio.png',
  },
  // supernumeraria
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/grande/superior/final.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/grande/superior/inicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/grande/inferior/final.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/grande/inferior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/pequenio/superior/final.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/pequenio/superior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/pequenio/inferior/final.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 26,
    Imagen: 'assets/img/hallazgos/supernumeraria/pequenio/inferior/inicio.png',
  },
  // transposicion
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/grande/superior/final.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/grande/superior/inicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/grande/inferior/final.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/grande/inferior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/pequenio/superior/final.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/pequenio/superior/inicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/pequenio/inferior/final.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 38,
    Imagen: 'assets/img/hallazgos/transposicion/pequenio/inferior/inicio.png',
  },
  // dos imagenes por filtro (bien y mal)
  // corona
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/grande/superior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/grande/superior/mal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/grande/inferior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/grande/inferior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 3,
    Imagen: 'assets/img/hallazgos/corona/pequenio/inferior/mal.png',
  },
  // edentulo
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/grande/superior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/grande/superior/mal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/grande/inferior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/grande/inferior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 7,
    Imagen: 'assets/img/hallazgos/edentulo/pequenio/inferior/mal.png',
  },
  // pulpotomia
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/grande/superior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/grande/superior/mal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/grande/inferior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/grande/inferior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 27,
    Imagen: 'assets/img/hallazgos/pulpotomia/pequenio/inferior/mal.png',
  },
  // sellantes
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/grande/superior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/grande/superior/mal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/grande/inferior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/grande/inferior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 35,
    Imagen: 'assets/img/hallazgos/sellante/pequenio/inferior/mal.png',
  },
  // conducto
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/grande/superior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/grande/superior/mal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/grande/inferior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/grande/inferior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 37,
    Imagen: 'assets/img/hallazgos/conducto/pequenio/inferior/mal.png',
  },
  // ortodoncia remobible
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/grande/superior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/grande/superior/mal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/grande/inferior/bien.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/grande/inferior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 2,
    Imagen: 'assets/img/hallazgos/ortodonciaremobible/pequenio/inferior/mal.png',
  },
  // seis imagenes por filtro (bienmedio, bienfinal, bieninicio, malmedio, malfinal, malinicio)
  // ortodoncia fija
  // superior grande
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/superior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/superior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/superior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/superior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/superior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/superior/malfinal.png',
  },
  // inferior grende
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/inferior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/inferior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/inferior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/inferior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/inferior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/grande/inferior/malfinal.png',
  },
  // inferior grande
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/superior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/superior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/superior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/superior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/superior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/superior/malfinal.png',
  },
  // inferior pequeñio
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/inferior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/inferior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/inferior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/inferior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/inferior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 1,
    Imagen: 'assets/img/hallazgos/ortodonciafija/pequenio/inferior/malfinal.png',
  },
  // protesis parcial fija
  // superior grande
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/superior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/superior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/superior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/superior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/superior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/superior/malfinal.png',
  },
  // superior pequenio
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/inferior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/inferior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/inferior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/inferior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/inferior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/grande/inferior/malfinal.png',
  },
  // inferior grande
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/superior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/superior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/superior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/superior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/superior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/superior/malfinal.png',
  },
  // inferior pequenio
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/inferior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/inferior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/inferior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/inferior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/inferior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 29,
    Imagen: 'assets/img/hallazgos/protesisparcialfija/pequenio/inferior/malfinal.png',
  },
  // protesis completa
  // superior grande
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/superior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/superior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/superior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/superior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/superior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/superior/malfinal.png',
  },
  // superior pequenio
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/inferior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/inferior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/inferior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/inferior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/inferior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/grande/inferior/malfinal.png',
  },
  // inferior grande
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/superior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/superior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/superior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/superior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/superior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/superior/malfinal.png',
  },
  // inferior pequenio
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/inferior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/inferior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/inferior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/inferior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/inferior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 30,
    Imagen: 'assets/img/hallazgos/protesiscompleta/pequenio/inferior/malfinal.png',
  },
  // protesis parcial remobible
  // superior grande
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/superior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/superior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/superior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/superior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/superior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/superior/malfinal.png',
  },
  // superior pequenio
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/inferior/bieninicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/inferior/bienmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/inferior/bienfinal.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/inferior/malinicio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/inferior/malmedio.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/grande/inferior/malfinal.png',
  },
  // inferior grande
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/superior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/superior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/superior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/superior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/superior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/superior/malfinal.png',
  },
  // inferior pequenio
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/inferior/bieninicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/inferior/bienmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/inferior/bienfinal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/inferior/malinicio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/inferior/malmedio.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 31,
    Imagen: 'assets/img/hallazgos/protesisparcialremobible/pequenio/inferior/malfinal.png',
  },
  // varias imagenes
  // espigo
  // superior grande
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/bien10.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/superior/mal10.png',
  },
  // inferior grande
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/bien1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/bien2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/bien3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/bien4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/mal1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/mal2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/mal3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/grande/inferior/mal4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/pequenio/superior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/pequenio/superior/mal.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/pequenio/inferior/bien.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 8,
    Imagen: 'assets/img/hallazgos/espigo/pequenio/inferior/mal.png',
  },
  // superficie desgastada
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/10.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/11.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/12.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/13.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/14.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/15.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/16.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/17.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/18.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/19.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/20.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/21.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/superior/22.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/5.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/6.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/7.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/8.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/9.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/10.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/11.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/12.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/13.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/14.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/15.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/16.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/17.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/18.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/19.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/20.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/21.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/grande/inferior/22.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/superior/1.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/superior/2.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/superior/3.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/superior/4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/superior/5.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/inferior/1.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/inferior/2.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/inferior/3.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/inferior/4.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 36,
    Imagen: 'assets/img/hallazgos/desgaste/pequenio/inferior/5.png',
  },
  // fractura
  {
    Magnitud: 1, Posicion: 1, Hallazgoid: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, Hallazgoid: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/10.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/11.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/12.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/13.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/14.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/15.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/16.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/superior/17.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/5.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/6.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/7.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/8.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/9.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/10.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/11.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/12.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/13.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/14.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/15.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/16.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/grande/inferior/17.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/1.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/2.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/3.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/5.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/6.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/7.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/8.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/9.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/10.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/superior/11.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/1.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/2.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/3.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/4.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/5.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/6.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/7.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/8.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/9.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/10.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 10,
    Imagen: 'assets/img/hallazgos/fractura/pequenio/inferior/11.png',
  },
  // muchisimas imagenes  
  // caries
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/10.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/11.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/12.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/13.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/14.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/15.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/16.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/superior/17.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/5.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/6.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/7.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/8.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/9.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/10.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/11.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/12.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/13.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/14.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/15.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/16.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/grande/inferior/17.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/superior/1.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/superior/2.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/superior/3.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/superior/4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/superior/5.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/inferior/1.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/inferior/2.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/inferior/3.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/inferior/4.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 16,
    Imagen: 'assets/img/hallazgos/caries/pequenio/inferior/5.png',
  },
    // restauraciones temporales
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/10.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/11.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/12.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/13.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/14.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/15.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/16.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/superior/17.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/5.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/6.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/7.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/8.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/9.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/10.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/11.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/12.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/13.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/14.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/15.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/16.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/grande/inferior/17.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/superior/1.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/superior/2.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/superior/3.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/superior/4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/superior/5.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/inferior/1.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/inferior/2.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/inferior/3.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/inferior/4.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 34,
    Imagen: 'assets/img/hallazgos/restauraciontemporal/pequenio/inferior/5.png',
  },
  // restauraciones definitivas
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/10.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/11.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/bien/12.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/1.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/2.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/3.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/4.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/5.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/6.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/7.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/8.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/9.png',
  },
  {
    Magnitud: 1, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/superior/mal/10.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/5.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/6.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/7.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/8.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/9.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/10.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/11.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/bien/12.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/1.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/2.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/3.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/4.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/5.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/6.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/7.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/8.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/9.png',
  },
  {
    Magnitud: 1, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/grande/inferior/mal/10.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/bien/1.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/bien/2.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/bien/3.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/bien/4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/bien/5.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/mal/1.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/mal/2.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/mal/3.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/mal/4.png',
  },
  {
    Magnitud: 2, Posicion: 1, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/superior/mal/5.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/bien/1.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/bien/2.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/bien/3.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/bien/4.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/bien/5.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/mal/1.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/mal/2.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/mal/3.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/mal/4.png',
  },
  {
    Magnitud: 2, Posicion: 2, HallazgoId: 33,
    Imagen: 'assets/img/hallazgos/restauraciondefinitiva/pequenio/inferior/mal/5.png',
  },
];

// datos de diagnosticos
diagnosticos = [
  { Nombre: 'Caries del esmalte', CodigoCIE10: 'K02.0' },
  { Nombre: 'Caries de la dentina', CodigoCIE10: 'K02.1' },
  { Nombre: 'Caries dental, no especificada', CodigoCIE10: 'K02.9' },
  { Nombre: 'Gingivitis aguda', CodigoCIE10: 'K05.0' },
  { Nombre: 'Periodontitis aguda', CodigoCIE10: 'K05.2' },
  { Nombre: 'Periodontitis crónica', CodigoCIE10: 'K05.3' },
  { Nombre: 'Gingivitis crónica', CodigoCIE10: 'K05.1' },
  { Nombre: 'Pérdida de dientes por accidente', CodigoCIE10: 'K08.1' },
  { Nombre: 'Absceso periapical sin fístula', CodigoCIE10: 'K04.7' },
  { Nombre: 'Absceso periapical con fístula', CodigoCIE10: 'K04.6' },
  { Nombre: 'Pulpitis reversible', CodigoCIE10: 'K04.01' },
  { Nombre: 'Pulpitis irreversible', CodigoCIE10: 'K04.02' },
  { Nombre: 'Necrosis pulpar', CodigoCIE10: 'K04.1' },
  { Nombre: 'Trastornos de la erupción dentaria', CodigoCIE10: 'K00.6' },
  { Nombre: 'Diente impactado', CodigoCIE10: 'K01.1' },
  { Nombre: 'Diente supernumerario', CodigoCIE10: 'K00.1' },
  { Nombre: 'Maloclusión, clase I', CodigoCIE10: 'K07.20' },
  { Nombre: 'Maloclusión, clase II', CodigoCIE10: 'K07.21' },
  { Nombre: 'Maloclusión, clase III', CodigoCIE10: 'K07.22' },
  { Nombre: 'Maloclusión, no especificada', CodigoCIE10: 'K07.4' },
  { Nombre: 'Fractura de diente', CodigoCIE10: 'S02.5' },
  { Nombre: 'Estomatitis aftosa recurrente', CodigoCIE10: 'K12.0' },
  { Nombre: 'Leucoplasia oral', CodigoCIE10: 'K13.2' },
  { Nombre: 'Candidiasis oral', CodigoCIE10: 'B37.0' },
  { Nombre: 'Glositis', CodigoCIE10: 'K14.0' },
  { Nombre: 'Trastorno de la articulación temporomandibular', CodigoCIE10: 'K07.6' },
  { Nombre: 'Anodoncia', CodigoCIE10: 'K00.0' },
  { Nombre: 'Desgaste dental excesivo', CodigoCIE10: 'K03.0' },
  { Nombre: 'Abrasión dental', CodigoCIE10: 'K03.1' },
  { Nombre: 'Erosión dental', CodigoCIE10: 'K03.2' },
  { Nombre: 'Bruxismo', CodigoCIE10: 'F45.8' },
  { Nombre: 'Quiste radicular', CodigoCIE10: 'K04.8' },
  { Nombre: 'Hiperplasia gingival', CodigoCIE10: 'K06.1' },
  { Nombre: 'Atrofia de la cresta alveolar', CodigoCIE10: 'K08.2' },
  { Nombre: 'Diente retenido', CodigoCIE10: 'K01.0' },
  { Nombre: 'Traumatismo dental, no especificado', CodigoCIE10: 'S03.2' },
  { Nombre: 'Fisura del paladar', CodigoCIE10: 'Q35.9' },
  { Nombre: 'Labio leporino unilateral', CodigoCIE10: 'Q36.9' },
  { Nombre: 'Hipersensibilidad dentinaria', CodigoCIE10: 'K03.8' },
  { Nombre: 'Torus mandibular', CodigoCIE10: 'K10.0' },
  { Nombre: 'Torus palatino', CodigoCIE10: 'K10.1' },
  { Nombre: 'Estomatitis, no especificada', CodigoCIE10: 'K12.1' },
  { Nombre: 'Trastornos de la mucosa oral', CodigoCIE10: 'K13.7' },
  { Nombre: 'Frenillo lingual corto', CodigoCIE10: 'Q38.1' },
  { Nombre: 'Sialoadenitis', CodigoCIE10: 'K11.2' },
  { Nombre: 'Mucocele de glándula salival', CodigoCIE10: 'K11.6' },
  { Nombre: 'Trastorno del desarrollo del esmalte', CodigoCIE10: 'K00.4' },
  { Nombre: 'Diente discrómico', CodigoCIE10: 'K00.7' },
  { Nombre: 'Fluorosis dental', CodigoCIE10: 'K00.3' },
  { Nombre: 'Lesión traumática de la mucosa oral', CodigoCIE10: 'K13.1' }
];

// Método para exportar datos a un archivo JSON
exports.insertData = async (req, res) => {
  try {
    await sequelize.sync(); // Asegurar que la base de datos está sincronizada
    console.log('📌 Empezando con la Insercion de Datos');
    await sequelize.transaction(
      async (t) => {
        await EstadoAgendamiento.bulkCreate(
          estadosagendamiento,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de agendamiento insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EstadoIncidencia.bulkCreate(
          estadosincidencia,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de incidencia insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EstadoUsuario.bulkCreate(
          estadosusuario,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de usuario insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await FuenteCaptacion.bulkCreate(
          fuentescaptacion,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Fuentes de captación insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await Genero.bulkCreate(
          generos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Generos insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await GradoInstruccion.bulkCreate(
          gradosdeinstruccion,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Grados de instrucción insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Relacion.bulkCreate(
          relaciones,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Relaciones insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await Vinculacion.bulkCreate(
          vinculaciones,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Vinculaciones insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoAfiliacion.bulkCreate(
          tiposafiliacion,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de afiliación insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoIncidencia.bulkCreate(
          tiposincidencia,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de incidencia insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoPago.bulkCreate(
          tipospago,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de pago insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoRespuesta.bulkCreate(
          tiposderesponsa,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de respuesta insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoProveedor.bulkCreate(
          tiposproveedor,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de proveedor insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoIngreso.bulkCreate(
          tiposingreso,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de ingreso insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoCampania.bulkCreate(
          tiposdecampania,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de campania insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EstadoCampania.bulkCreate(
          estadosdecampania,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de campania insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Periodo.bulkCreate(
          periodos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Periodos insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoActividad.bulkCreate(
          tiposdeactividad,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de actividad insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoDocumento.bulkCreate(
          tiposdocumento,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de documento insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EstadoOrdenLaboratorio.bulkCreate(
          estadosordendelaboratorio,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de orden de laboratorio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EstadoPago.bulkCreate(
          estadospago,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de pago insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await CargoUsuario.bulkCreate(
          cargosusuario,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Cargos de usuario insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoUsuario.bulkCreate(
          tiposusuario,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de usuario insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Servicio.bulkCreate(
          servicios,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Servicios insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Profesion.bulkCreate(
          profesiones,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Profesiones insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await Iafa.bulkCreate(
          iafas,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 IAFAS insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await Empresa.bulkCreate(
          empresas,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Empresa insertada correctamente');
    await sequelize.transaction(
      async (t) => {
        await Sede.bulkCreate(
          sedes,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Sedes insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoDocPDF.bulkCreate(
          tiposdocumentoPDF,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos Documento insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await CategoriaPatrimonio.bulkCreate(
          categoriaspatrimonio,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Categorias de Patrimonio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await SubCategoriaPatrimonio.bulkCreate(
          subcategoriaspatrimonio,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Sub Categorias de Patrimonio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await CategoriaInventario.bulkCreate(
          categoriasinvetario,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Categorias de Inventario insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await SubCategoriaInventario.bulkCreate(
          subcategoriasinventario,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Sub Categorias de Inventario insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Almacen.bulkCreate(
          almacenes,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Almacenes de Inventario insertados correctamente');
    // await sequelize.transaction(
    //   async (t) => {
    //     await EstadoIncidencia.bulkCreate(
    //       estadosincidencia,
    //       {
    //         transaction: t,
    //         ignoreDuplicates: true
    //       }
    //     );
    //   }
    // );
    for (const usuario of usuarios) {
      const lacontra = usuario.Contrasenia;
      const hashedPassword = await bcrypt.hash(lacontra, 10);
      await Usuario.findOrCreate(
        {
          where: {
            Correo: usuario.Correo,
            Celular: usuario.Celular,
            Documento: usuario.Documento
          },
          defaults: {
            ...usuario,
            Contrasenia: hashedPassword // Encriptar la contraseña antes de guardar
          }
        }
      );
    }
    console.log('📌 Usuarios insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Paciente.bulkCreate(
          pacientes,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Pacientes insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoDiente.bulkCreate(
          tipos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos Diente insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Cuadrante.bulkCreate(
          cuadrantes,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Cuadrantes insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Ubicacion.bulkCreate(
          ubicaciones,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Ubicaciones insertadas correctamente');
    await sequelize.transaction(
      async (t) => {
        await Diente.bulkCreate(
          dientes,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Dientes insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await TipoConcentimiento.bulkCreate(
          tiposdeoperacion,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tipos de operación insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Hallazgo.bulkCreate(
          hallazgos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Hallazgos NT 188 - MINSA insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Radiografia.bulkCreate(
          radiografias,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Clasificacion de Radiografia insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EmpresaRadiografia.bulkCreate(
          empresasradiografia,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Empresa de Radiografia insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await ItemRadiografia.bulkCreate(
          itemsradiografia,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Item de Radiografia insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Laboratorio.bulkCreate(
          laboratorios,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Clasificacion de Laboratorio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EmpresaLaboratorio.bulkCreate(
          empresaslaboratorio,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Empresa de Laboratorio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await ItemLaboratorio.bulkCreate(
          itemslaboratorio,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Item de Laboratorio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await SubItemLaboratorio.bulkCreate(
          subitemslaboratorio,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 SubItem de Laboratorio insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Diagnostico.bulkCreate(
          diagnosticos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Diagnosticos insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await EstadoDiente.bulkCreate(
          estadosdeldiente,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Estados de Diente con su respectiva imagen insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Categoria.bulkCreate(
          categorias,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Categorias insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Procedimiento.bulkCreate(
          procedimientos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Procedimientos insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Catalogo.bulkCreate(
          catalogos,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Catalogos insertados correctamente');
    await sequelize.transaction(
      async (t) => {
        await Tarifario.bulkCreate(
          tarifarios,
          {
            transaction: t,
            ignoreDuplicates: true
          }
        );
      }
    );
    console.log('📌 Tarifarios insertados correctamente');
    res.status(200).json({
      message: 'Datos insertados correctamente'
    });
  } catch (error) {
    console.error('❌ Error insertando Datos:', error);
  }
};